/*
 * Decompiled with CFR 0.152.
 */
package com.android.extensions.appfunctions;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Bundle;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class AppFunctionException
extends Exception {
    public static final int ERROR_DENIED = 1000;
    public static final int ERROR_INVALID_ARGUMENT = 1001;
    public static final int ERROR_DISABLED = 1002;
    public static final int ERROR_FUNCTION_NOT_FOUND = 1003;
    public static final int ERROR_SYSTEM_ERROR = 2000;
    public static final int ERROR_CANCELLED = 2001;
    public static final int ERROR_APP_UNKNOWN_ERROR = 3000;
    public static final int ERROR_CATEGORY_UNKNOWN = 0;
    public static final int ERROR_CATEGORY_REQUEST_ERROR = 1;
    public static final int ERROR_CATEGORY_SYSTEM = 2;
    public static final int ERROR_CATEGORY_APP = 3;
    private final int mErrorCode;
    @Nullable
    private final String mErrorMessage;
    @NonNull
    private final Bundle mExtras;

    public AppFunctionException(int errorCode, @Nullable String errorMessage) {
        this(errorCode, errorMessage, Bundle.EMPTY);
    }

    public AppFunctionException(int errorCode, @Nullable String errorMessage, @NonNull Bundle extras) {
        this.mErrorCode = errorCode;
        this.mErrorMessage = errorMessage;
        this.mExtras = extras;
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    @Nullable
    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public int getErrorCategory() {
        if (this.mErrorCode >= 1000 && this.mErrorCode < 2000) {
            return 1;
        }
        if (this.mErrorCode >= 2000 && this.mErrorCode < 3000) {
            return 2;
        }
        if (this.mErrorCode >= 3000 && this.mErrorCode < 4000) {
            return 3;
        }
        return 0;
    }

    @NonNull
    public Bundle getExtras() {
        return this.mExtras;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ErrorCategory {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ErrorCode {
    }
}

