/*
 * Decompiled with CFR 0.152.
 */
package com.android.extensions.appfunctions;

import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.content.Context;
import android.os.CancellationSignal;
import android.os.OutcomeReceiver;
import com.android.extensions.appfunctions.AppFunctionException;
import com.android.extensions.appfunctions.ExecuteAppFunctionRequest;
import com.android.extensions.appfunctions.ExecuteAppFunctionResponse;
import com.android.extensions.appfunctions.SidecarConverter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.concurrent.Executor;

public final class AppFunctionManager {
    public static final int APP_FUNCTION_STATE_DEFAULT = 0;
    public static final int APP_FUNCTION_STATE_ENABLED = 1;
    public static final int APP_FUNCTION_STATE_DISABLED = 2;
    private final android.app.appfunctions.AppFunctionManager mManager;
    private final Context mContext;

    public AppFunctionManager(Context context) {
        this.mContext = Objects.requireNonNull(context);
        this.mManager = (android.app.appfunctions.AppFunctionManager)context.getSystemService(android.app.appfunctions.AppFunctionManager.class);
        if (this.mManager == null) {
            throw new IllegalStateException("Underlying AppFunctionManager system service not found.");
        }
    }

    @RequiresPermission(anyOf={"android.permission.EXECUTE_APP_FUNCTIONS_TRUSTED", "android.permission.EXECUTE_APP_FUNCTIONS"}, conditional=true)
    public void executeAppFunction(@NonNull ExecuteAppFunctionRequest sidecarRequest, @NonNull Executor executor, @NonNull CancellationSignal cancellationSignal, final @NonNull OutcomeReceiver<ExecuteAppFunctionResponse, AppFunctionException> callback) {
        Objects.requireNonNull(sidecarRequest);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        android.app.appfunctions.ExecuteAppFunctionRequest platformRequest = SidecarConverter.getPlatformExecuteAppFunctionRequest(sidecarRequest);
        this.mManager.executeAppFunction(platformRequest, executor, cancellationSignal, (OutcomeReceiver)new OutcomeReceiver<android.app.appfunctions.ExecuteAppFunctionResponse, android.app.appfunctions.AppFunctionException>(){

            public void onResult(android.app.appfunctions.ExecuteAppFunctionResponse result) {
                callback.onResult((Object)SidecarConverter.getSidecarExecuteAppFunctionResponse(result));
            }

            public void onError(android.app.appfunctions.AppFunctionException exception) {
                callback.onError((Throwable)SidecarConverter.getSidecarAppFunctionException(exception));
            }
        });
    }

    @RequiresPermission(anyOf={"android.permission.EXECUTE_APP_FUNCTIONS_TRUSTED", "android.permission.EXECUTE_APP_FUNCTIONS"}, conditional=true)
    public void isAppFunctionEnabled(@NonNull String functionIdentifier, @NonNull String targetPackage, @NonNull Executor executor, @NonNull OutcomeReceiver<Boolean, Exception> callback) {
        this.mManager.isAppFunctionEnabled(functionIdentifier, targetPackage, executor, callback);
    }

    public void isAppFunctionEnabled(@NonNull String functionIdentifier, @NonNull Executor executor, @NonNull OutcomeReceiver<Boolean, Exception> callback) {
        this.mManager.isAppFunctionEnabled(functionIdentifier, executor, callback);
    }

    @SuppressLint(value={"WrongConstant"})
    public void setAppFunctionEnabled(@NonNull String functionIdentifier, int newEnabledState, @NonNull Executor executor, @NonNull OutcomeReceiver<Void, Exception> callback) {
        this.mManager.setAppFunctionEnabled(functionIdentifier, newEnabledState, executor, callback);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EnabledState {
    }
}

