/*
 * Decompiled with CFR 0.152.
 */
package com.android.extensions.appfunctions;

import android.annotation.NonNull;
import android.app.appsearch.GenericDocument;
import android.os.Bundle;
import java.util.Objects;

public final class ExecuteAppFunctionRequest {
    @NonNull
    private final String mTargetPackageName;
    @NonNull
    private final String mFunctionIdentifier;
    @NonNull
    private final Bundle mExtras;
    @NonNull
    private final GenericDocument mParameters;

    private ExecuteAppFunctionRequest(@NonNull String targetPackageName, @NonNull String functionIdentifier, @NonNull Bundle extras, @NonNull GenericDocument parameters) {
        this.mTargetPackageName = Objects.requireNonNull(targetPackageName);
        this.mFunctionIdentifier = Objects.requireNonNull(functionIdentifier);
        this.mExtras = Objects.requireNonNull(extras);
        this.mParameters = Objects.requireNonNull(parameters);
    }

    @NonNull
    public String getTargetPackageName() {
        return this.mTargetPackageName;
    }

    @NonNull
    public String getFunctionIdentifier() {
        return this.mFunctionIdentifier;
    }

    @NonNull
    public GenericDocument getParameters() {
        return this.mParameters;
    }

    @NonNull
    public Bundle getExtras() {
        return this.mExtras;
    }

    public static final class Builder {
        @NonNull
        private final String mTargetPackageName;
        @NonNull
        private final String mFunctionIdentifier;
        @NonNull
        private Bundle mExtras = Bundle.EMPTY;
        @NonNull
        private GenericDocument mParameters = new GenericDocument.Builder("", "", "").build();

        public Builder(@NonNull String targetPackageName, @NonNull String functionIdentifier) {
            this.mTargetPackageName = Objects.requireNonNull(targetPackageName);
            this.mFunctionIdentifier = Objects.requireNonNull(functionIdentifier);
        }

        @NonNull
        public Builder setExtras(@NonNull Bundle extras) {
            this.mExtras = Objects.requireNonNull(extras);
            return this;
        }

        @NonNull
        public Builder setParameters(@NonNull GenericDocument parameters) {
            Objects.requireNonNull(parameters);
            this.mParameters = parameters;
            return this;
        }

        @NonNull
        public ExecuteAppFunctionRequest build() {
            return new ExecuteAppFunctionRequest(this.mTargetPackageName, this.mFunctionIdentifier, this.mExtras, this.mParameters);
        }
    }
}

