/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* The following code was generated by JFlex 1.7.0 tweaked for IntelliJ platform */

package androidx.com.android.tools.idea.lang.aidl.lexer;

import com.intellij.lexer.FlexLexer;
import com.intellij.psi.tree.IElementType;

import static com.intellij.psi.TokenType.BAD_CHARACTER;
import static com.intellij.psi.TokenType.WHITE_SPACE;
import static androidx.com.android.tools.idea.lang.aidl.lexer.AidlTokenTypes.*;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.7.0
 * from the specification file <tt>_AidlLexer.flex</tt>
 */
public class _AidlLexer implements FlexLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0, 0
  };

  /** 
   * Translates characters to character classes
   * Chosen bits are [10, 6, 5]
   * Total runtime size is 4224 bytes
   */
  public static int ZZ_CMAP(int ch) {
    return ZZ_CMAP_A[(ZZ_CMAP_Y[(ZZ_CMAP_Z[ch>>11]<<6)|((ch>>5)&0x3f)]<<5)|(ch&0x1f)];
  }

  /* The ZZ_CMAP_Z table has 544 entries */
  static final char ZZ_CMAP_Z[] = zzUnpackCMap(
    "\1\0\1\1\1\2\1\3\1\4\1\5\1\6\15\5\1\7\1\10\11\5\1\11\1\12\1\5\1\13\1\14\11"+
    "\5\1\15\14\5\1\16\2\5\1\17\u01e2\5");

  /* The ZZ_CMAP_Y table has 1024 entries */
  static final char ZZ_CMAP_Y[] = zzUnpackCMap(
    "\1\0\1\1\1\2\1\3\1\4\1\5\55\6\1\7\3\6\1\10\6\6\1\7\14\6\1\11\3\6\1\11\3\6"+
    "\1\11\3\6\1\11\3\6\1\11\3\6\1\11\3\6\1\11\3\6\1\11\3\6\1\11\3\6\1\11\2\6\1"+
    "\10\3\6\1\10\2\6\1\7\10\6\1\7\1\6\1\10\57\6\1\5\12\6\1\7\1\10\11\6\1\11\3"+
    "\6\1\10\5\6\1\12\5\6\1\10\2\6\1\10\4\6\1\12\35\6\1\13\1\14\1\15\175\6\1\5"+
    "\160\6\1\7\24\6\1\10\1\6\1\7\5\6\2\10\2\6\1\10\14\6\1\10\130\6\1\10\54\6\1"+
    "\7\35\6\1\11\3\6\1\10\1\6\1\16\4\6\1\10\10\6\1\10\12\6\1\10\3\6\1\10\13\6"+
    "\1\10\3\6\1\7\2\6\1\10\15\6\1\7\32\6\1\10\60\6\1\7\6\6\1\10\143\6\1\17\1\20"+
    "\12\6\1\10\65\6");

  /* The ZZ_CMAP_A table has 544 entries */
  static final char ZZ_CMAP_A[] = zzUnpackCMap(
    "\11\0\1\3\1\2\2\1\1\2\22\0\1\3\1\73\1\22\2\0\1\67\1\70\1\21\1\52\1\53\1\5"+
    "\1\66\1\64\1\17\1\15\1\4\1\12\7\6\1\11\1\6\1\62\1\63\1\54\1\65\1\55\1\0\1"+
    "\76\4\25\1\16\1\25\5\24\1\7\13\24\1\13\2\24\1\60\1\23\1\61\1\72\1\44\1\0\1"+
    "\27\1\34\1\31\1\46\1\32\1\20\1\42\1\45\1\35\1\24\1\41\1\33\1\36\1\43\1\37"+
    "\1\26\1\24\1\30\1\47\1\40\1\10\1\75\1\50\1\13\1\51\1\24\1\56\1\71\1\57\1\74"+
    "\6\0\1\1\32\0\1\3\77\0\12\14\46\0\12\14\14\0\12\14\20\0\12\14\6\0\12\14\6"+
    "\0\13\3\35\0\2\1\5\0\1\3\57\0\1\3\26\0\12\14\16\0\62\14");

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\1\2\1\3\1\4\1\5\2\6\1\5"+
    "\1\7\1\10\1\6\2\1\12\6\1\11\1\12\1\13"+
    "\1\14\1\15\1\16\1\17\1\20\1\21\1\22\1\23"+
    "\1\24\1\25\1\26\1\27\1\30\1\31\1\32\1\33"+
    "\1\6\1\34\1\35\1\0\1\5\3\0\1\36\1\6"+
    "\1\0\1\36\2\6\2\0\1\37\1\0\11\6\1\40"+
    "\5\6\1\41\1\42\1\43\1\44\1\45\1\46\1\47"+
    "\1\50\1\6\1\0\1\5\1\36\1\0\1\6\1\51"+
    "\2\6\1\52\1\37\13\6\1\53\1\54\5\6\1\55"+
    "\1\6\1\51\1\0\6\6\1\56\1\57\1\60\1\6"+
    "\1\61\4\6\1\62\2\6\1\63\1\64\1\51\1\65"+
    "\1\66\3\6\1\67\2\6\1\70\3\6\1\71\4\6"+
    "\1\72\1\6\1\73\1\74\1\6\1\75\1\6\1\76"+
    "\6\6\1\77\1\100\1\101";

  private static int [] zzUnpackAction() {
    int [] result = new int[172];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\77\0\176\0\275\0\77\0\374\0\u013b\0\u017a"+
    "\0\u01b9\0\u01f8\0\77\0\u0237\0\u0276\0\u02b5\0\u02f4\0\u0333"+
    "\0\u0372\0\u03b1\0\u03f0\0\u042f\0\u046e\0\u04ad\0\u04ec\0\u052b"+
    "\0\77\0\77\0\u056a\0\u05a9\0\77\0\77\0\77\0\77"+
    "\0\77\0\77\0\77\0\u05e8\0\77\0\77\0\u0627\0\u0666"+
    "\0\77\0\u06a5\0\77\0\u06e4\0\77\0\u0723\0\u0762\0\u07a1"+
    "\0\u07e0\0\u01f8\0\u081f\0\77\0\u085e\0\u089d\0\u08dc\0\u091b"+
    "\0\u095a\0\u0999\0\u02b5\0\77\0\u09d8\0\u0a17\0\u0a56\0\u0a95"+
    "\0\u0ad4\0\u0b13\0\u0b52\0\u0b91\0\u0bd0\0\u0c0f\0\u0c4e\0\u0c8d"+
    "\0\u0ccc\0\u0d0b\0\u0d4a\0\u0d89\0\77\0\77\0\77\0\77"+
    "\0\77\0\77\0\77\0\77\0\u0dc8\0\u0e07\0\77\0\u0e46"+
    "\0\u0e85\0\u0ec4\0\u0f03\0\u0f42\0\u0f81\0\77\0\u02b5\0\u0fc0"+
    "\0\u0fff\0\u103e\0\u107d\0\u10bc\0\u10fb\0\u113a\0\u1179\0\u11b8"+
    "\0\u11f7\0\u1236\0\u1275\0\u013b\0\u12b4\0\u12f3\0\u1332\0\u1371"+
    "\0\u13b0\0\77\0\u13ef\0\u142e\0\u146d\0\u14ac\0\u14eb\0\u152a"+
    "\0\u1569\0\u15a8\0\u15e7\0\u013b\0\u013b\0\u013b\0\u1626\0\u013b"+
    "\0\u1665\0\u16a4\0\u16e3\0\u1722\0\u013b\0\u1761\0\u17a0\0\u013b"+
    "\0\u013b\0\77\0\u013b\0\u013b\0\u17df\0\u181e\0\u185d\0\u013b"+
    "\0\u189c\0\u18db\0\u013b\0\u191a\0\u1959\0\u1998\0\u013b\0\u19d7"+
    "\0\u1a16\0\u1a55\0\u1a94\0\u013b\0\u1ad3\0\u013b\0\u013b\0\u1b12"+
    "\0\u013b\0\u1b51\0\u013b\0\u1b90\0\u1bcf\0\u1c0e\0\u1c4d\0\u1c8c"+
    "\0\u1ccb\0\u013b\0\u013b\0\u013b";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[172];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\2\3\3\1\4\1\5\1\6\1\7\1\10\1\6"+
    "\1\11\1\7\1\2\1\12\1\7\1\13\1\14\1\15"+
    "\1\16\1\2\2\7\1\17\2\7\1\20\1\21\1\22"+
    "\1\23\1\24\1\7\1\25\1\26\5\7\1\27\1\30"+
    "\2\7\1\31\1\32\1\33\1\34\1\35\1\36\1\37"+
    "\1\40\1\41\1\42\1\43\1\44\1\45\1\46\1\47"+
    "\1\50\1\51\1\52\1\53\1\54\1\55\100\0\3\3"+
    "\77\0\1\56\1\57\77\0\1\6\1\60\1\61\2\6"+
    "\2\0\1\62\1\63\1\0\1\64\11\0\1\63\1\60"+
    "\51\0\6\7\2\0\1\7\1\0\1\7\3\0\26\7"+
    "\23\0\1\7\7\0\6\7\2\0\1\7\1\0\1\7"+
    "\3\0\17\7\1\65\6\7\23\0\1\7\7\0\1\6"+
    "\1\60\1\61\2\6\1\66\1\0\1\62\1\63\1\0"+
    "\1\64\11\0\1\63\1\60\51\0\1\67\2\0\2\67"+
    "\72\0\6\7\2\0\1\7\1\0\1\7\3\0\3\7"+
    "\1\70\3\7\1\71\16\7\23\0\1\7\1\0\1\72"+
    "\2\0\74\72\22\73\1\74\1\75\53\73\6\0\6\7"+
    "\2\0\1\7\1\0\1\7\3\0\3\7\1\76\22\7"+
    "\23\0\1\7\7\0\6\7\2\0\1\7\1\0\1\7"+
    "\3\0\2\7\1\77\10\7\1\100\5\7\1\101\4\7"+
    "\23\0\1\7\7\0\6\7\2\0\1\7\1\0\1\7"+
    "\3\0\17\7\1\102\6\7\23\0\1\7\7\0\6\7"+
    "\2\0\1\7\1\0\1\7\3\0\13\7\1\103\12\7"+
    "\23\0\1\7\7\0\6\7\2\0\1\7\1\0\1\7"+
    "\3\0\13\7\1\104\11\7\1\105\23\0\1\7\7\0"+
    "\6\7\2\0\1\7\1\0\1\7\3\0\12\7\1\106"+
    "\4\7\1\107\6\7\23\0\1\7\7\0\2\7\1\110"+
    "\3\7\2\0\1\7\1\0\1\7\3\0\17\7\1\111"+
    "\6\7\23\0\1\7\7\0\6\7\2\0\1\7\1\0"+
    "\1\7\3\0\4\7\1\112\21\7\23\0\1\7\7\0"+
    "\6\7\2\0\1\7\1\0\1\7\3\0\13\7\1\113"+
    "\12\7\23\0\1\7\7\0\6\7\2\0\1\7\1\0"+
    "\1\7\3\0\21\7\1\114\4\7\23\0\1\7\55\0"+
    "\1\115\10\0\1\116\66\0\1\117\7\0\1\120\76\0"+
    "\1\121\101\0\1\122\77\0\1\123\72\0\1\124\17\0"+
    "\6\7\2\0\1\7\1\0\1\7\3\0\13\7\1\125"+
    "\12\7\23\0\1\7\1\0\2\56\1\0\74\56\5\57"+
    "\1\126\71\57\10\0\1\61\77\0\1\127\73\0\1\130"+
    "\2\0\2\130\4\0\1\131\46\0\1\131\16\0\6\7"+
    "\2\0\1\7\1\0\1\7\3\0\11\7\1\132\14\7"+
    "\23\0\1\7\7\0\1\133\2\0\2\133\1\0\1\133"+
    "\1\0\1\133\1\0\1\133\4\0\1\133\1\0\1\133"+
    "\1\0\2\133\1\0\1\133\11\0\1\133\36\0\1\67"+
    "\2\0\2\67\3\0\1\63\1\0\1\64\11\0\1\63"+
    "\52\0\6\7\2\0\1\7\1\0\1\7\3\0\7\7"+
    "\1\134\16\7\23\0\1\7\7\0\6\7\2\0\1\7"+
    "\1\0\1\7\3\0\13\7\1\135\12\7\23\0\1\7"+
    "\22\0\1\136\55\0\22\73\1\137\1\75\53\73\6\0"+
    "\6\7\2\0\1\7\1\0\1\7\3\0\4\7\1\140"+
    "\1\141\20\7\23\0\1\7\7\0\6\7\2\0\1\7"+
    "\1\0\1\7\3\0\2\7\1\142\23\7\23\0\1\7"+
    "\7\0\6\7\2\0\1\7\1\0\1\7\3\0\17\7"+
    "\1\143\6\7\23\0\1\7\7\0\6\7\2\0\1\7"+
    "\1\0\1\7\3\0\3\7\1\144\22\7\23\0\1\7"+
    "\7\0\2\7\1\145\3\7\2\0\1\7\1\0\1\7"+
    "\3\0\26\7\23\0\1\7\7\0\6\7\2\0\1\7"+
    "\1\0\1\7\3\0\17\7\1\146\6\7\23\0\1\7"+
    "\7\0\6\7\2\0\1\7\1\0\1\7\3\0\13\7"+
    "\1\147\12\7\23\0\1\7\7\0\6\7\2\0\1\7"+
    "\1\0\1\7\3\0\14\7\1\150\11\7\23\0\1\7"+
    "\7\0\6\7\2\0\1\7\1\0\1\7\3\0\2\7"+
    "\1\151\23\7\23\0\1\7\7\0\6\7\2\0\1\7"+
    "\1\0\1\7\3\0\13\7\1\152\1\153\11\7\23\0"+
    "\1\7\7\0\6\7\2\0\1\7\1\0\1\7\3\0"+
    "\14\7\1\154\11\7\23\0\1\7\7\0\6\7\2\0"+
    "\1\7\1\0\1\7\3\0\6\7\1\155\17\7\23\0"+
    "\1\7\7\0\2\7\1\156\3\7\2\0\1\7\1\0"+
    "\1\7\3\0\26\7\23\0\1\7\7\0\2\7\1\157"+
    "\3\7\2\0\1\7\1\0\1\7\3\0\26\7\23\0"+
    "\1\7\7\0\6\7\2\0\1\7\1\0\1\7\3\0"+
    "\13\7\1\160\12\7\23\0\1\7\7\0\6\7\2\0"+
    "\1\7\1\0\1\7\3\0\11\7\1\161\14\7\23\0"+
    "\1\7\1\0\4\57\1\162\1\126\71\57\6\0\1\130"+
    "\2\0\2\130\5\0\1\64\64\0\1\130\2\0\2\130"+
    "\72\0\6\7\2\0\1\7\1\0\1\7\3\0\13\7"+
    "\1\163\12\7\23\0\1\7\7\0\1\133\1\164\1\165"+
    "\2\133\1\0\1\133\1\0\1\133\1\0\1\133\4\0"+
    "\1\133\1\0\1\133\1\0\2\133\1\164\1\133\11\0"+
    "\1\133\36\0\6\7\2\0\1\7\1\0\1\7\3\0"+
    "\23\7\1\166\2\7\23\0\1\7\7\0\6\7\2\0"+
    "\1\7\1\0\1\7\3\0\3\7\1\167\22\7\23\0"+
    "\1\7\7\0\6\7\2\0\1\7\1\0\1\7\3\0"+
    "\5\7\1\170\20\7\23\0\1\7\7\0\6\7\2\0"+
    "\1\7\1\0\1\7\3\0\15\7\1\171\10\7\23\0"+
    "\1\7\7\0\6\7\2\0\1\7\1\0\1\7\3\0"+
    "\20\7\1\172\5\7\23\0\1\7\7\0\6\7\2\0"+
    "\1\7\1\0\1\7\3\0\23\7\1\173\2\7\23\0"+
    "\1\7\7\0\6\7\2\0\1\7\1\0\1\7\3\0"+
    "\4\7\1\174\21\7\23\0\1\7\7\0\6\7\2\0"+
    "\1\7\1\0\1\7\3\0\12\7\1\175\13\7\23\0"+
    "\1\7\7\0\6\7\2\0\1\7\1\0\1\7\3\0"+
    "\16\7\1\176\7\7\23\0\1\7\7\0\6\7\2\0"+
    "\1\7\1\0\1\7\3\0\7\7\1\177\16\7\23\0"+
    "\1\7\7\0\6\7\2\0\1\7\1\0\1\7\3\0"+
    "\6\7\1\200\17\7\23\0\1\7\7\0\6\7\2\0"+
    "\1\7\1\0\1\7\3\0\13\7\1\201\12\7\23\0"+
    "\1\7\7\0\2\7\1\202\3\7\2\0\1\7\1\0"+
    "\1\7\3\0\26\7\23\0\1\7\7\0\6\7\2\0"+
    "\1\7\1\0\1\7\3\0\6\7\1\203\17\7\23\0"+
    "\1\7\7\0\6\7\2\0\1\7\1\0\1\7\3\0"+
    "\24\7\1\204\1\7\23\0\1\7\7\0\6\7\2\0"+
    "\1\7\1\0\1\7\3\0\6\7\1\205\17\7\23\0"+
    "\1\7\7\0\6\7\2\0\1\7\1\0\1\7\3\0"+
    "\10\7\1\206\15\7\23\0\1\7\7\0\6\7\2\0"+
    "\1\7\1\0\1\7\3\0\4\7\1\207\21\7\23\0"+
    "\1\7\7\0\6\7\2\0\1\7\1\0\1\7\3\0"+
    "\22\7\1\210\3\7\23\0\1\7\7\0\6\7\2\0"+
    "\1\7\1\0\1\7\3\0\17\7\1\211\6\7\23\0"+
    "\1\7\11\0\1\165\77\0\1\212\73\0\6\7\2\0"+
    "\1\7\1\0\1\7\3\0\6\7\1\213\17\7\23\0"+
    "\1\7\7\0\6\7\2\0\1\7\1\0\1\7\3\0"+
    "\14\7\1\214\11\7\23\0\1\7\7\0\6\7\2\0"+
    "\1\7\1\0\1\7\3\0\6\7\1\215\17\7\23\0"+
    "\1\7\7\0\6\7\2\0\1\7\1\0\1\7\3\0"+
    "\3\7\1\216\22\7\23\0\1\7\7\0\6\7\2\0"+
    "\1\7\1\0\1\7\3\0\21\7\1\217\4\7\23\0"+
    "\1\7\7\0\6\7\2\0\1\7\1\0\1\7\3\0"+
    "\14\7\1\220\11\7\23\0\1\7\7\0\6\7\2\0"+
    "\1\7\1\0\1\7\3\0\6\7\1\221\17\7\23\0"+
    "\1\7\7\0\6\7\2\0\1\7\1\0\1\7\3\0"+
    "\4\7\1\222\21\7\23\0\1\7\7\0\6\7\2\0"+
    "\1\7\1\0\1\7\3\0\14\7\1\223\11\7\23\0"+
    "\1\7\7\0\6\7\2\0\1\7\1\0\1\7\3\0"+
    "\4\7\1\224\21\7\23\0\1\7\7\0\6\7\2\0"+
    "\1\7\1\0\1\7\3\0\3\7\1\225\22\7\23\0"+
    "\1\7\7\0\6\7\2\0\1\7\1\0\1\7\3\0"+
    "\7\7\1\226\16\7\23\0\1\7\7\0\6\7\2\0"+
    "\1\7\1\0\1\7\3\0\14\7\1\227\11\7\23\0"+
    "\1\7\7\0\6\7\2\0\1\7\1\0\1\7\3\0"+
    "\7\7\1\230\16\7\23\0\1\7\7\0\6\7\2\0"+
    "\1\7\1\0\1\7\3\0\16\7\1\231\7\7\23\0"+
    "\1\7\7\0\6\7\2\0\1\7\1\0\1\7\3\0"+
    "\6\7\1\232\17\7\23\0\1\7\7\0\6\7\2\0"+
    "\1\7\1\0\1\7\3\0\3\7\1\233\22\7\23\0"+
    "\1\7\7\0\6\7\2\0\1\7\1\0\1\7\3\0"+
    "\14\7\1\234\11\7\23\0\1\7\7\0\6\7\2\0"+
    "\1\7\1\0\1\235\3\0\26\7\23\0\1\7\7\0"+
    "\6\7\2\0\1\7\1\0\1\7\3\0\25\7\1\236"+
    "\23\0\1\7\7\0\6\7\2\0\1\7\1\0\1\7"+
    "\3\0\6\7\1\237\17\7\23\0\1\7\7\0\6\7"+
    "\2\0\1\7\1\0\1\7\3\0\3\7\1\240\22\7"+
    "\23\0\1\7\7\0\6\7\2\0\1\7\1\0\1\7"+
    "\3\0\6\7\1\241\17\7\23\0\1\7\7\0\6\7"+
    "\2\0\1\7\1\0\1\7\3\0\3\7\1\242\22\7"+
    "\23\0\1\7\7\0\6\7\2\0\1\7\1\0\1\7"+
    "\3\0\17\7\1\243\6\7\23\0\1\7\7\0\6\7"+
    "\2\0\1\7\1\0\1\7\3\0\3\7\1\244\22\7"+
    "\23\0\1\7\7\0\6\7\2\0\1\7\1\0\1\7"+
    "\3\0\10\7\1\245\15\7\23\0\1\7\7\0\6\7"+
    "\2\0\1\7\1\0\1\7\3\0\22\7\1\246\3\7"+
    "\23\0\1\7\7\0\6\7\2\0\1\7\1\0\1\7"+
    "\3\0\5\7\1\247\20\7\23\0\1\7\7\0\6\7"+
    "\2\0\1\7\1\0\1\7\3\0\7\7\1\250\16\7"+
    "\23\0\1\7\7\0\6\7\2\0\1\7\1\0\1\7"+
    "\3\0\6\7\1\251\17\7\23\0\1\7\7\0\6\7"+
    "\2\0\1\7\1\0\1\7\3\0\6\7\1\252\17\7"+
    "\23\0\1\7\7\0\6\7\2\0\1\7\1\0\1\7"+
    "\3\0\6\7\1\253\17\7\23\0\1\7\7\0\6\7"+
    "\2\0\1\7\1\0\1\7\3\0\4\7\1\254\21\7"+
    "\23\0\1\7\1\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[7434];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String[] ZZ_ERROR_MSG = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\1\11\2\1\1\11\5\1\1\11\15\1\2\11"+
    "\2\1\7\11\1\1\2\11\2\1\1\11\1\1\1\11"+
    "\1\1\1\11\1\1\1\0\1\1\3\0\1\11\1\1"+
    "\1\0\3\1\2\0\1\11\1\0\17\1\10\11\1\1"+
    "\1\0\1\11\1\1\1\0\4\1\1\11\23\1\1\11"+
    "\2\1\1\0\24\1\1\11\42\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[172];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private CharSequence zzBuffer = "";

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /**
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
  public _AidlLexer() {
    this((java.io.Reader)null);
  }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public _AidlLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    int size = 0;
    for (int i = 0, length = packed.length(); i < length; i += 2) {
      size += packed.charAt(i);
    }
    char[] map = new char[size];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < packed.length()) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }

  public final int getTokenStart() {
    return zzStartRead;
  }

  public final int getTokenEnd() {
    return getTokenStart() + yylength();
  }

  public void reset(CharSequence buffer, int start, int end, int initialState) {
    zzBuffer = buffer;
    zzCurrentPos = zzMarkedPos = zzStartRead = start;
    zzAtEOF  = false;
    zzAtBOL = true;
    zzEndRead = end;
    yybegin(initialState);
  }

  /**
   * Refills the input buffer.
   *
   * @return      {@code false}, iff there was new input.
   *
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {
    return true;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final CharSequence yytext() {
    return zzBuffer.subSequence(zzStartRead, zzMarkedPos);
  }


  /**
   * Returns the character at position {@code pos} from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer.charAt(zzStartRead+pos);
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public IElementType advance() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    CharSequence zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL/*, zzEndReadL*/);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL/*, zzEndReadL*/);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + ZZ_CMAP(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        return null;
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { return BAD_CHARACTER;
            } 
            // fall through
          case 66: break;
          case 2: 
            { return WHITE_SPACE;
            } 
            // fall through
          case 67: break;
          case 3: 
            { return DIVIDE;
            } 
            // fall through
          case 68: break;
          case 4: 
            { return MULTIPLY;
            } 
            // fall through
          case 69: break;
          case 5: 
            { return INTVALUE;
            } 
            // fall through
          case 70: break;
          case 6: 
            { return IDENTIFIER;
            } 
            // fall through
          case 71: break;
          case 7: 
            { return DOT;
            } 
            // fall through
          case 72: break;
          case 8: 
            { return MINUS;
            } 
            // fall through
          case 73: break;
          case 9: 
            { return LPAREN;
            } 
            // fall through
          case 74: break;
          case 10: 
            { return RPAREN;
            } 
            // fall through
          case 75: break;
          case 11: 
            { return LT;
            } 
            // fall through
          case 76: break;
          case 12: 
            { return GT;
            } 
            // fall through
          case 77: break;
          case 13: 
            { return LBRACE;
            } 
            // fall through
          case 78: break;
          case 14: 
            { return RBRACE;
            } 
            // fall through
          case 79: break;
          case 15: 
            { return LBRACKET;
            } 
            // fall through
          case 80: break;
          case 16: 
            { return RBRACKET;
            } 
            // fall through
          case 81: break;
          case 17: 
            { return COLON;
            } 
            // fall through
          case 82: break;
          case 18: 
            { return SEMICOLON;
            } 
            // fall through
          case 83: break;
          case 19: 
            { return COMMA;
            } 
            // fall through
          case 84: break;
          case 20: 
            { return ASSIGN;
            } 
            // fall through
          case 85: break;
          case 21: 
            { return PLUS;
            } 
            // fall through
          case 86: break;
          case 22: 
            { return MODULO;
            } 
            // fall through
          case 87: break;
          case 23: 
            { return BITWISE_AND;
            } 
            // fall through
          case 88: break;
          case 24: 
            { return BITWISE_OR;
            } 
            // fall through
          case 89: break;
          case 25: 
            { return BITWISE_XOR;
            } 
            // fall through
          case 90: break;
          case 26: 
            { return NOT;
            } 
            // fall through
          case 91: break;
          case 27: 
            { return BITWISE_COMPLEMENT;
            } 
            // fall through
          case 92: break;
          case 28: 
            { return AT;
            } 
            // fall through
          case 93: break;
          case 29: 
            { return COMMENT;
            } 
            // fall through
          case 94: break;
          case 30: 
            { return FLOATVALUE;
            } 
            // fall through
          case 95: break;
          case 31: 
            { return C_STR;
            } 
            // fall through
          case 96: break;
          case 32: 
            { return IN_KEYWORD;
            } 
            // fall through
          case 97: break;
          case 33: 
            { return LSHIFT;
            } 
            // fall through
          case 98: break;
          case 34: 
            { return LEQ;
            } 
            // fall through
          case 99: break;
          case 35: 
            { return RSHIFT;
            } 
            // fall through
          case 100: break;
          case 36: 
            { return GEQ;
            } 
            // fall through
          case 101: break;
          case 37: 
            { return EQUALITY;
            } 
            // fall through
          case 102: break;
          case 38: 
            { return LOGICAL_AND;
            } 
            // fall through
          case 103: break;
          case 39: 
            { return LOGICAL_OR;
            } 
            // fall through
          case 104: break;
          case 40: 
            { return NEQ;
            } 
            // fall through
          case 105: break;
          case 41: 
            { return HEXVALUE;
            } 
            // fall through
          case 106: break;
          case 42: 
            { return CHARVALUE;
            } 
            // fall through
          case 107: break;
          case 43: 
            { return INT_KEYWORD;
            } 
            // fall through
          case 108: break;
          case 44: 
            { return OUT_KEYWORD;
            } 
            // fall through
          case 109: break;
          case 45: 
            { return BLOCK_COMMENT;
            } 
            // fall through
          case 110: break;
          case 46: 
            { return CHAR_KEYWORD;
            } 
            // fall through
          case 111: break;
          case 47: 
            { return ENUM_KEYWORD;
            } 
            // fall through
          case 112: break;
          case 48: 
            { return LONG_KEYWORD;
            } 
            // fall through
          case 113: break;
          case 49: 
            { return BYTE_KEYWORD;
            } 
            // fall through
          case 114: break;
          case 50: 
            { return TRUE_KEYWORD;
            } 
            // fall through
          case 115: break;
          case 51: 
            { return VOID_KEYWORD;
            } 
            // fall through
          case 116: break;
          case 52: 
            { return UNION_KEYWORD;
            } 
            // fall through
          case 117: break;
          case 53: 
            { return FALSE_KEYWORD;
            } 
            // fall through
          case 118: break;
          case 54: 
            { return FLOAT_KEYWORD;
            } 
            // fall through
          case 119: break;
          case 55: 
            { return CONST_KEYWORD;
            } 
            // fall through
          case 120: break;
          case 56: 
            { return INOUT_KEYWORD;
            } 
            // fall through
          case 121: break;
          case 57: 
            { return SHORT_KEYWORD;
            } 
            // fall through
          case 122: break;
          case 58: 
            { return IMPORT_KEYWORD;
            } 
            // fall through
          case 123: break;
          case 59: 
            { return ONEWAY_KEYWORD;
            } 
            // fall through
          case 124: break;
          case 60: 
            { return DOUBLE_KEYWORD;
            } 
            // fall through
          case 125: break;
          case 61: 
            { return PACKAGE_KEYWORD;
            } 
            // fall through
          case 126: break;
          case 62: 
            { return BOOLEAN_KEYWORD;
            } 
            // fall through
          case 127: break;
          case 63: 
            { return INTERFACE_KEYWORD;
            } 
            // fall through
          case 128: break;
          case 64: 
            { return PARCELABLE_KEYWORD;
            } 
            // fall through
          case 129: break;
          case 65: 
            { return CPP_HEADER_KEYWORD;
            } 
            // fall through
          case 130: break;
          default:
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
