/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.integration.macrobenchmark

import android.content.Intent
import androidx.benchmark.macro.CompilationMode
import androidx.benchmark.macro.MacrobenchmarkConfig
import androidx.benchmark.macro.MacrobenchmarkRule
import androidx.benchmark.macro.StartupMode
import androidx.benchmark.macro.StartupTimingMetric

const val TargetPackage = "androidx.compose.integration.macrobenchmark.target"

/**
 * Simplified interface for standardizing e.g. package,
 * compilation types, and iteration count across project
 */
fun MacrobenchmarkRule.measureStartup(
    profileCompiled: Boolean,
    startupMode: StartupMode,
    iterations: Int = 5,
    setupIntent: Intent.() -> Unit = {}
) = measureStartupRepeated(
    MacrobenchmarkConfig(
        packageName = TargetPackage,
        metrics = listOf(StartupTimingMetric()),
        compilationMode = if (profileCompiled) {
            CompilationMode.SpeedProfile(warmupIterations = 3)
        } else {
            CompilationMode.None
        },
        iterations = iterations
    ),
    startupMode = startupMode
) {
    pressHome()
    val intent = Intent()
    intent.setPackage(TargetPackage)
    setupIntent(intent)
    launchIntentAndWait(intent)
}