/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.ui.util

import org.junit.Assert.assertEquals
import org.junit.Test
import org.junit.runner.RunWith
import org.junit.runners.JUnit4

@RunWith(JUnit4::class)
class InlineClassHelperTest {

    @Test
    fun packAndUnpackFloats() {
        val first = Float.MAX_VALUE
        val second = Float.MIN_VALUE
        val packed = packFloats(first, second)
        assertEquals(first, unpackFloat1(packed))
        assertEquals(second, unpackFloat2(packed))
    }

    @Test
    fun packAndUnpackInts() {
        val first = Int.MAX_VALUE
        val second = Int.MIN_VALUE
        val packed = packInts(first, second)
        assertEquals(first, unpackInt1(packed))
        assertEquals(second, unpackInt2(packed))
    }
}