package com.example.appsearch;

import androidx.appsearch.app.AppSearchSchema;
import androidx.appsearch.app.GenericDocument;
import java.lang.String;

class $$__AppSearch__Gift {
  public static final String SCHEMA_TYPE = "Gift";

  public static final AppSearchSchema SCHEMA = new AppSearchSchema.Builder(SCHEMA_TYPE)
    .addProperty(new AppSearchSchema.PropertyConfig.Builder("newName")
      .setDataType(AppSearchSchema.PropertyConfig.DATA_TYPE_STRING)
      .setCardinality(AppSearchSchema.PropertyConfig.CARDINALITY_OPTIONAL)
      .setTokenizerType(AppSearchSchema.PropertyConfig.TOKENIZER_TYPE_PLAIN)
      .setIndexingType(AppSearchSchema.PropertyConfig.INDEXING_TYPE_NONE)
      .build())
    .build();

  public GenericDocument toGenericDocument(Gift dataClass) {
    GenericDocument.Builder<?> builder =
        new GenericDocument.Builder<>(dataClass.uri, SCHEMA_TYPE);
    String oldNameCopy = dataClass.oldName;
    if (oldNameCopy != null) {
      builder.setProperty("newName", oldNameCopy);
    }
    return builder.build();
  }

  public Gift fromGenericDocument(GenericDocument genericDoc) {
    String[] oldNameCopy = genericDoc.getPropertyStringArray("newName");
    String oldNameConv = null;
    if (oldNameCopy != null && oldNameCopy.length != 0) {
      oldNameConv = oldNameCopy[0];
    }
    Gift dataClass = new Gift();
    dataClass.oldName = oldNameConv;
    return dataClass;
  }
}
