/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.camera.camera2.pipe.impl

import android.content.Context
import android.hardware.camera2.CameraManager
import androidx.camera.camera2.pipe.CameraPipe
import androidx.camera.camera2.pipe.Cameras
import dagger.Binds
import dagger.Component
import dagger.Module
import dagger.Provides
import dagger.Reusable
import javax.inject.Singleton

@Singleton
@Component(modules = [CameraPipeModule::class])
interface CameraPipeComponent {
    fun cameraGraphComponentBuilder(): CameraGraphComponent.Builder
    fun cameras(): Cameras
}

@Module(
    includes = [CameraPipeBindings::class],
    subcomponents = [CameraGraphComponent::class]
)
class CameraPipeModule(private val config: CameraPipe.Config) {
    @Provides
    fun provideCameraPipeConfig(): CameraPipe.Config = config
}

@Module
abstract class CameraPipeBindings {
    @Binds
    abstract fun bindCameras(impl: CamerasImpl): Cameras

    companion object {
        @Provides
        fun provideContext(config: CameraPipe.Config): Context = config.appContext

        @Reusable
        @Provides
        fun provideCameraManager(context: Context): CameraManager =
            context.getSystemService(Context.CAMERA_SERVICE) as CameraManager
    }
}