/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.ui.test

import android.os.Bundle
import android.view.Gravity
import android.widget.FrameLayout
import androidx.activity.ComponentActivity
import androidx.compose.Composable
import androidx.compose.Recomposer
import androidx.ui.core.setContent

// The presence of an ActionBar follows from the theme set in AndroidManifest.xml
class ActivityWithActionBar : ComponentActivity() {
    private lateinit var composeHolder: FrameLayout

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        val root = FrameLayout(this)
        composeHolder = FrameLayout(this).apply {
            layoutParams = FrameLayout.LayoutParams(100, 100).apply {
                gravity = Gravity.BOTTOM or Gravity.END
            }
            // Set background color for recognizability on screen / in screenshots
            setBackgroundColor(android.graphics.Color.LTGRAY)
        }
        root.addView(composeHolder)
        setContentView(root)
    }

    fun setContent(composable: @Composable () -> Unit) {
        composeHolder.setContent(Recomposer.current(), composable)
    }
}
