/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.paging

import java.util.ArrayList

@Suppress("DEPRECATION")
class TestPositionalDataSource<T : Any>(list: List<T>) : PositionalDataSource<T>() {
    private val list: List<T> = ArrayList(list)

    override fun loadInitial(params: LoadInitialParams, callback: LoadInitialCallback<T>) {
        val totalCount = list.size
        val position = computeInitialLoadPosition(
            params,
            totalCount
        )
        val loadSize = computeInitialLoadSize(
            params,
            position,
            totalCount
        )

        // for simplicity, we could return everything immediately,
        // but we tile here since it's expected behavior
        val sublist = list.subList(position, position + loadSize)
        callback.onResult(sublist, position, totalCount)
    }

    override fun loadRange(params: LoadRangeParams, callback: LoadRangeCallback<T>) {
        val end = minOf(list.size, params.startPosition + params.loadSize)
        callback.onResult(list.subList(params.startPosition, end))
    }
}
