/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.benchmark.macro.perfetto

import androidx.benchmark.macro.createTempFileFromAsset
import androidx.benchmark.perfetto.PerfettoHelper
import androidx.benchmark.perfetto.PerfettoTraceProcessor
import androidx.test.ext.junit.runners.AndroidJUnit4
import androidx.test.filters.MediumTest
import kotlin.test.assertEquals
import org.junit.Assume.assumeTrue
import org.junit.Test
import org.junit.runner.RunWith

@RunWith(AndroidJUnit4::class)
class MemoryCountersQueryTest {
    @Test
    @MediumTest
    fun fixedTrace31() {
        assumeTrue(PerfettoHelper.isAbiSupported())
        val traceFile = createTempFileFromAsset("api31_startup_cold", ".perfetto-trace")
        val metrics = PerfettoTraceProcessor.runSingleSessionServer(
            traceFile.absolutePath
        ) {
            MemoryCountersQuery.getMemoryCounters(
                this,
                "androidx.benchmark.integration.macrobenchmark.target"
            )
        }
        val expectedMetrics = MemoryCountersQuery.SubMetrics(
            minorPageFaults = 3431.0,
            majorPageFaults = 6.0,
            pageFaultsBackedBySwapCache = 0.0,
            pageFaultsBackedByReadIO = 8.0,
            memoryCompactionEvents = 0.0,
            memoryReclaimEvents = 0.0
        )
        assertEquals(expectedMetrics, metrics)
    }
}
