/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.collection

internal class CircularyArrayAddFromHeadAndPopFromTailBenchmark(
    private val seed: List<String>,
) : CollectionBenchmark {
    override fun measuredBlock() {
        val array = CircularArray<String>()
        for (e in seed) {
            array.addFirst(e)
        }

        repeat(seed.size) {
            array.popLast()
        }
    }
}

internal fun createSeed(size: Int): List<String> = List(size) {
    "element $it"
}
