# build_log_simplifier validation failures

If build_log_simplifier failed your build, then your change caused the AndroidX build to generate new build output messages

# Why is new build output important?

   *   This new output might contain new warnings. If you can fix these issues, please do so

   *   Developers in the future might encounter unrelated build failures, and could have difficulty diagnosing them due to being distracted/confused by the output that you would be adding now

# Can I see the full Gradle output?

   *   The full output from Gradle (before build_log_simplifier.py processes it) should be found in gradle.log

       *   If your build failed on the build server, you can download gradle.log via your browser:

           *   Press the left arrow to go back to the screen that lists build server artifacts

           *   Press "ctrl-f" and search for the file that you are looking for

           *   Click the file to download it

# How can I update the baseline file?

##   Where is the baseline file?

   *   Exemptions for output that is always/deterministically generated by the build go in [messages.ignore](https://android.googlesource.com/platform/frameworks/support/+/androidx-main/development/build_log_simplifier/messages.ignore)

       *   We may periodically garbage collect exemptions in this file via [update.sh --gc](https://android.googlesource.com/platform/frameworks/support/+/androidx-main/development/build_log_simplifier/update.sh), so they may be automatically removed after their underlying issue is fixed

       *   In most cases, this will be the correct file to update

   *   Exemptions for output that is only sometimes (flakily) generated by the build go in [message-flakes.ignore](https://android.googlesource.com/platform/frameworks/support/+/androidx-main/development/build_log_simplifier/message-flakes.ignore)

       *   These exemptions will not be automatically garbage collected

##   What changes do I make to the baseline file?

   *   If the build failed on a build server:

       *   You may automatically update the baseline to include the output for a given build id

           *   Run `./development/build_log_simplifier/update.sh ${buildId}`

   *   If your build failed on your computer, you can copy the suggested exemptions file

        *    If your build failed on your computer, you can read its instructions about where to copy the suggested exemptions file from

   *   You can manually edit the exemptions file

       *   These build message exemptions files are each a list of regular expressions and comments, which you can modify manually

       *   If you would like to test your changes to the exemptions file without having to rerun Gradle, you can download gradle.log (see above) and ask build_log_simplifier.py to validate the result:

           *   `frameworks/support $ development/build_log_simplifier.py --validate ~/gradle.log`
