## wrapper/gradle-wrapper.properties

Keeps track of Gradle version used by androidx. When updating the version a new version prebuilt needs to be added to `tools/external/gradle` repository.

## libs.versions.toml

Keeps track of library and plugin dependencies used by androidx. Adding or updating a library there requires running `./development/importMaven/importMaven.sh myartifact:here:1.0.0`

## verification-keyring.keys

Checked-in [local keyring](https://docs.gradle.org/current/userguide/dependency_verification.html#sec:local-keyring)
that is used to avoid reaching out to key servers whenever a key is required by Gradle to verify an
artifact.

AndroidX only uses human readable `verification-keyring.keys`. Gradle also generates binary
`verification-keyring.gpg`, but it is optional, and thus we do not use it.

To update this file, after adding the relevant dependencies to the build, run:
```
development/update-verification-metadata.sh
```

## verification-metadata.xml

[Configuration file for Gradle dependency verification](https://docs.gradle.org/current/userguide/dependency_verification.html#sub:verification-metadata) used by androidx to make sure dependencies are [signed with trusted signatures](https://docs.gradle.org/current/userguide/dependency_verification.html#sec:signature-verificationn) and that unsigned artifacts have [expected checksums](https://docs.gradle.org/current/userguide/dependency_verification.html#sec:checksum-verification).

When adding a new artifact, first run:
```
development/update-verification-metadata.sh
```
to trust the signature (or checksum) of the new artifact.

Then, if any checksums were added, make sure they're associated with a bug that is tracking
an effort to build or acquire a signed version of this dependency.  To associate with a bug,
please add an `androidx:reason` attribute to a string that contains a URL for a bug filed
either in buganizer or github:

```xml
<component group="g" name="g" version="3.1" androidx:reason="Unsigned b/8675309">
  <artifact name="g-3.1.jar">
    <sha256
      value="f5759b7fcdfc83a525a036deedcbd32e5b536b625ebc282426f16ca137eb5902"
      origin="Generated by Gradle"
    />
  </artifact>
</component>
```

### If that doesn't work.

If the artifact is not signed, and does not get automatically added to
verification-metadata.xml when you go through the above process, it's possible it's a
dependency of a [detached configuration](https://docs.gradle.org/current/userguide/dependency_verification.html#sec:bootstrapping-verification).

In this case, your best option may be to generate and add the checksum by hand, to at least
protect against any future tampering with the current artifact file.  To do this, for an
artifact file foo.tar.gz, run: `sha256 foo.tar.gz`.  This will generate a sha256 checksum that
you can hand-add to verification-metadata.xml following the example of other entries.  For
example, this is where the current checksum for kotlin-native-prebuilt-linux-x86_64 came from.
