/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// VERSION: v0_001 (Inspired by androidx.compose.material3.tokens v0_126)

package androidx.tv.material3.tokens

internal object ColorDarkTokens {
    val Background = PaletteTokens.Neutral10
    val Error = PaletteTokens.Error80
    val ErrorContainer = PaletteTokens.Error30
    val InverseOnSurface = PaletteTokens.Neutral20
    val InversePrimary = PaletteTokens.Primary40
    val InverseSurface = PaletteTokens.Neutral90
    val OnBackground = PaletteTokens.Neutral90
    val OnError = PaletteTokens.Error20
    val OnErrorContainer = PaletteTokens.Error90
    val OnPrimary = PaletteTokens.Primary20
    val OnPrimaryContainer = PaletteTokens.Primary90
    val OnSecondary = PaletteTokens.Secondary20
    val OnSecondaryContainer = PaletteTokens.Secondary90
    val OnSurface = PaletteTokens.Neutral90
    val OnSurfaceVariant = PaletteTokens.NeutralVariant80
    val OnTertiary = PaletteTokens.Tertiary20
    val OnTertiaryContainer = PaletteTokens.Tertiary90
    val Border = PaletteTokens.NeutralVariant60
    val BorderVariant = PaletteTokens.NeutralVariant30
    val Primary = PaletteTokens.Primary80
    val PrimaryContainer = PaletteTokens.Primary30
    val Scrim = PaletteTokens.Neutral0
    val Secondary = PaletteTokens.Secondary80
    val SecondaryContainer = PaletteTokens.Secondary30
    val Surface = PaletteTokens.Neutral10
    val SurfaceTint = Primary
    val SurfaceVariant = PaletteTokens.NeutralVariant30
    val Tertiary = PaletteTokens.Tertiary80
    val TertiaryContainer = PaletteTokens.Tertiary30
}
