/*
 * Decompiled with CFR 0.152.
 */
package com.android.support.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtility;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.regex.Pattern;

public final class MismatchedAnnotationCheck
extends AbstractCheck {
    private static final String MSG_KEY_JAVADOC_DUPLICATE_TAG = "javadoc.duplicateTag";
    private static final String MSG_KEY_JAVADOC_MISSING = "javadoc.missing";
    private String mTag;
    private Pattern mMatchTag;
    private String mAnnotationSimpleName;
    private String mAnnotation;
    private String mMessageKey;

    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    public void setTag(String tag) {
        this.mTag = tag;
        this.mMatchTag = CommonUtils.createPattern((String)("@" + tag + "(?:\\s|$)"));
    }

    public void setAnnotation(String annotation) {
        this.mAnnotation = annotation;
        int lastDollar = annotation.lastIndexOf(36);
        int lastSep = lastDollar >= 0 ? lastDollar : annotation.lastIndexOf(46);
        this.mAnnotationSimpleName = annotation.substring(lastSep + 1);
    }

    public void setMessageKey(String messageKey) {
        this.mMessageKey = messageKey;
    }

    public int[] getAcceptableTokens() {
        return new int[]{15, 14, 157, 154, 9, 8, 10, 155, 161};
    }

    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    public void visitToken(DetailAST ast) {
        boolean containsJavadocTag;
        boolean containsAnnotation = AnnotationUtility.containsAnnotation((DetailAST)ast, (String)this.mAnnotationSimpleName) || AnnotationUtility.containsAnnotation((DetailAST)ast, (String)this.mAnnotation);
        if (containsAnnotation ^ (containsJavadocTag = this.containsJavadocTag(ast))) {
            this.log(ast.getLineNo(), this.mMessageKey, new Object[0]);
        }
    }

    private boolean containsJavadocTag(DetailAST ast) {
        String[] lines;
        TextBlock javadoc = this.getFileContents().getJavadocBefore(ast.getLineNo());
        if (javadoc == null) {
            return false;
        }
        int currentLine = javadoc.getStartLineNo();
        boolean found = false;
        for (String line : lines = javadoc.getText()) {
            if (this.mMatchTag.matcher(line).find()) {
                if (found) {
                    this.log(currentLine, MSG_KEY_JAVADOC_DUPLICATE_TAG, new Object[]{this.mTag});
                }
                found = true;
            }
            ++currentLine;
        }
        return found;
    }
}

