/*
 * Copyright 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package androidx.ui.test

import androidx.ui.core.ComponentNode
import androidx.ui.core.SemanticsTreeNode
import androidx.ui.core.semantics.SemanticsConfiguration
import androidx.ui.engine.geometry.Rect

class SemanticsTreeNodeStub(override val data: SemanticsConfiguration) : SemanticsTreeNode {
    override val parent: SemanticsTreeNode?
        get() = null
    override val children: Set<SemanticsTreeNode> = setOf()
    override val globalRect: Rect? = null

    override fun findClosestParentNode(selector: (ComponentNode) -> Boolean): ComponentNode? {
        // TODO(b/143866294): currently we do not have a way of specifying a hierarchy in
        // FakeSemanticsTreeInteraction, this needs to be implemented after we stop flattening
        // the hierarchy
        return null
    }
}
