/*
 * Copyright 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.car.app.activity.renderer.surface;

import static androidx.annotation.RestrictTo.Scope.LIBRARY;

import androidx.annotation.RestrictTo;

/**
 * Interface to receive rotary events.
 *
 * @hide
 */
@RestrictTo(LIBRARY)
public interface RotaryEventCallback {
    /**
     * Notifies of a rotary rotation.
     *
     * @param steps the number of rotation steps detected. Should be a positive number
     * @param isClockwise true if the rotation direction is clockwise
     */
    void onRotate(int steps, boolean isClockwise);

    /**
     * Notifies of a nudge event.
     *
     * @param keyCode the nudge key code. It can be {@code KEYCODE_DPAD_RIGHT}, {@code
     * KEYCODE_DPAD_LEFT}, {@code KEYCODE_DPAD_UP}, {@code KEYCODE_DPAD_DOWN}.
     *
     * @return true if handled successfully
     */
    boolean onNudge(int keyCode);

    /** Will be called when rotary select is triggered. */
    void onSelect();
}
