/*
 * Copyright 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.build

/**
 * The list of versions codes of all the libraries in this project.
 */
object LibraryVersions {
    val ACTIVITY = Version("1.2.0-alpha01")
    val ADS_IDENTIFIER = Version("1.0.0-alpha03")
    val ANIMATION = Version("1.0.0-alpha01")
    val ANIMATION_TESTING = Version("1.1.0-alpha01")
    val ANNOTATION = Version("1.2.0-alpha01")
    val ANNOTATION_EXPERIMENTAL = Version("1.1.0-alpha01")
    val APPCOMPAT = Version("1.2.0-alpha01")
    val APPSEARCH = Version("1.0.0-alpha01")
    val ARCH_CORE = Version("2.2.0-alpha01")
    val ARCH_CORE_TESTING = ARCH_CORE
    val ARCH_RUNTIME = Version("2.2.0-alpha01")
    val ASYNCLAYOUTINFLATER = Version("1.1.0-alpha01")
    val AUTOFILL = Version("1.1.0-alpha01")
    val BENCHMARK = Version("1.1.0-alpha01")
    val BIOMETRIC = Version("1.1.0-alpha01")
    val BROWSER = Version("1.2.0-alpha10")
    val CAMERA = Version("1.0.0-alpha07")
    val CAMERA_EXTENSIONS = Version("1.0.0-alpha04")
    val CAMERA_LIFECYCLE = Version("1.0.0-alpha01")
    val CAMERA_VIEW = Version("1.0.0-alpha04")
    val CAR = Version("1.0.0-alpha8")
    val CAR_MODERATOR = Version("1.0.0-alpha1")
    val CARDVIEW = Version("1.1.0-alpha01")
    val COLLECTION = Version("1.2.0-alpha01")
    val CONTENTPAGER = Version("1.1.0-alpha01")
    val COMPOSE = Version("0.1.0-dev03")
    val CONTENTACCESS = Version("1.0.0-alpha01")
    val COORDINATORLAYOUT = Version("1.2.0-alpha01")
    val CORE = Version("1.3.0-alpha01")
    val CORE_ROLE = Version("1.0.0-beta01")
    val CURSORADAPTER = Version("1.1.0-alpha01")
    val CUSTOMVIEW = Version("1.1.0-alpha02")
    val DOCUMENTFILE = Version("1.1.0-alpha01")
    val DRAWERLAYOUT = Version("1.1.0-alpha03")
    val DYNAMICANIMATION = Version("1.1.0-alpha03")
    val DYNAMICANIMATION_KTX = Version("1.0.0-alpha03")
    val EMOJI = Version("1.1.0-alpha01")
    val ENTERPRISE = Version("1.1.0-alpha01")
    val EXIFINTERFACE = Version("1.2.0-alpha01")
    val FRAGMENT = Version("1.3.0-alpha01")
    val FUTURES = Version("1.1.0-alpha01")
    val GRIDLAYOUT = Version("1.1.0-alpha01")
    val HEIFWRITER = Version("1.1.0-alpha01")
    val INSPECTION = Version("1.0.0-alpha01")
    val INTERPOLATOR = Version("1.1.0-alpha01")
    val JETIFIER = Version("1.0.0-beta09")
    val LEANBACK = Version("1.1.0-alpha03")
    val LEANBACK_PREFERENCE = Version("1.1.0-alpha03")
    val LEGACY = Version("1.1.0-alpha01")
    val LOCALBROADCASTMANAGER = Version("1.1.0-alpha02")
    val LIFECYCLE = Version("2.3.0-alpha01")
    val LIFECYCLE_EXTENSIONS = LIFECYCLE
    val LOADER = Version("1.2.0-alpha01")
    val MEDIA = Version("1.2.0-alpha02")
    val MEDIA2_COMMON = Version("1.1.0-alpha01")
    val MEDIA2_PLAYER = Version("1.1.0-alpha01")
    val MEDIA2_SESSION = Version("1.1.0-alpha01")
    val MEDIA2_EXOPLAYER = Version("1.1.0-alpha01")
    val MEDIA2_WIDGET = Version("1.1.0-alpha01")
    val MEDIAROUTER = Version("1.2.0-alpha01")
    val NAVIGATION = Version("2.3.0-alpha01")
    val NAVIGATION_TESTING = Version("1.0.0-alpha08") // Unpublished
    val PAGING = Version("3.0.0-alpha01")
    val PALETTE = Version("1.1.0-alpha01")
    val PRINT = Version("1.1.0-alpha01")
    val PERCENTLAYOUT = Version("1.1.0-alpha01")
    val PREFERENCE = Version("1.2.0-alpha01")
    val RECOMMENDATION = Version("1.1.0-alpha01")
    val RECYCLERVIEW = Version("1.2.0-alpha01")
    val RECYCLERVIEW_SELECTION = Version("1.1.0-alpha07")
    val REMOTECALLBACK = Version("1.0.0-alpha02")
    val ROOM = Version("2.3.0-alpha01")
    val SAVEDSTATE = Version("1.1.0-alpha01")
    val SECURITY = Version("1.0.0-alpha03")
    val SECURITY_IDENTITY_CREDENTIAL = Version("1.0.0-alpha01")
    val SERIALIZATION = Version("1.0.0-alpha01")
    val SHARETARGET = Version("1.0.0-beta02")
    val SLICE = Version("1.1.0-alpha02")
    val SLICE_BENCHMARK = Version("1.1.0-alpha02")
    val SLICE_BUILDERS_KTX = Version("1.0.0-alpha08")
    val SLICE_REMOTECALLBACK = Version("1.0.0-alpha01")
    val SLIDINGPANELAYOUT = Version("1.1.0-alpha01")
    val SQLITE = Version("2.1.0-alpha01")
    val SWIPE_REFRESH_LAYOUT = Version("1.1.0-alpha04")
    val TEST_SCREENSHOT = Version("1.0.0-alpha01")
    val TEXTCLASSIFIER = Version("1.0.0-alpha03")
    val TRANSITION = Version("1.4.0-alpha01")
    val TVPROVIDER = Version("1.1.0-alpha01")
    val UI = Version("0.1.0-dev03")
    val VECTORDRAWABLE = Version("1.2.0-alpha01")
    val VECTORDRAWABLE_ANIMATED = Version("1.2.0-alpha01")
    val VERSIONED_PARCELABLE = Version("1.2.0-alpha01")
    val VIEWPAGER = Version("1.1.0-alpha01")
    val VIEWPAGER2 = Version("1.1.0-alpha01")
    val WEAR = Version("1.1.0-alpha01")
    val WEBKIT = Version("1.2.0-alpha01")
    val WORK = Version("2.3.0-beta01")
}
