/*
 * Copyright 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.room.integration.testapp.database;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;

import java.util.List;

/**
 * Simple Product DAO.
 */
@Dao
public interface ProductDao {

    /**
     * Insert the product.
     */
    @Insert
    void insert(Product product);

    /**
     * Insert a review.
     */
    @Insert
    void addReview(Review review);

    /**
     * Query a products reviews.
     */
    @Query("SELECT * FROM Review WHERE mProductId = :productId")
    List<Review> getProductReviews(int productId);

}
