/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.runtime.samples

import androidx.annotation.Sampled
import androidx.compose.runtime.Composable
import androidx.compose.runtime.Immutable
import androidx.compose.foundation.Text
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Column

@Sampled
@Composable
fun simpleImmutableClass() {
    @Immutable
    data class Person(val name: String, val phoneNumber: String)

    @Composable
    fun PersonView(person: Person) {
        Column {
            Row {
                Text("Name: ")
                Text(person.name)
            }
            Row {
                Text("Phone: ")
                Text(person.phoneNumber)
            }
        }
    }

    @Composable
    fun PeopleView(people: List<Person>) {
        Column {
            for (person in people) {
                PersonView(person)
            }
        }
    }
}