/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.car.app.versioning;

import androidx.annotation.IntDef;
import androidx.annotation.RestrictTo;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/** @hide */
@RestrictTo(RestrictTo.Scope.LIBRARY)
@IntDef(value = {
        CarAppApiLevels.UNKNOWN,
        CarAppApiLevels.LEVEL_1,
        CarAppApiLevels.LEVEL_2,
        CarAppApiLevels.LEVEL_3,
        CarAppApiLevels.LEVEL_4,
        CarAppApiLevels.LEVEL_5,
        CarAppApiLevels.LEVEL_6,
        CarAppApiLevels.LEVEL_7})
@Retention(RetentionPolicy.SOURCE)
public @interface CarAppApiLevel {
}
