/*
 * Copyright 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.wear.compose.integration.macrobenchmark.target

import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.PaddingValues
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.requiredHeight
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.semantics.contentDescription
import androidx.compose.ui.semantics.semantics
import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.dp
import androidx.wear.compose.foundation.lazy.ScalingLazyColumn
import androidx.wear.compose.foundation.lazy.rememberScalingLazyListState
import androidx.wear.compose.material.MaterialTheme
import androidx.wear.compose.material.Text

class ScrollActivity : ComponentActivity() {
    private var itemHeightDp: Dp = 20.dp
    private var defaultItemSpacingDp: Dp = 8.dp

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        setContent {
            MaterialTheme {
                ScalingLazyColumn(
                    horizontalAlignment = Alignment.CenterHorizontally,
                    verticalArrangement = Arrangement.spacedBy(
                        space = defaultItemSpacingDp,
                        alignment = Alignment.CenterVertically
                    ),
                    contentPadding = PaddingValues(horizontal = 8.dp, vertical = 30.dp),
                    state = rememberScalingLazyListState(),
                    modifier = Modifier.semantics { contentDescription = CONTENT_DESCRIPTION }
                ) {
                    items(5000) { it ->
                        Box(
                            Modifier
                                .requiredHeight(itemHeightDp)
                                .background(MaterialTheme.colors.surface)
                                .fillMaxSize()
                        ) {
                            Text(text = "Item $it", color = MaterialTheme.colors.onSurface)
                        }
                    }
                }
            }
        }
    }
}