/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.benchmark.integration.baselineprofile.flavors.producer

import androidx.benchmark.macro.CompilationMode
import androidx.benchmark.macro.StartupMode
import androidx.benchmark.macro.StartupTimingMetric
import androidx.benchmark.macro.junit4.MacrobenchmarkRule
import androidx.test.filters.LargeTest
import org.junit.Rule
import org.junit.Test

@LargeTest
class MacrobenchmarkTest {

    @get:Rule val benchmarkRule = MacrobenchmarkRule()

    @Test
    fun startupMacrobenchmark() =
        benchmarkRule.measureRepeated(
            packageName = PACKAGE_NAME,
            metrics = listOf(StartupTimingMetric()),
            compilationMode = CompilationMode.DEFAULT,
            iterations = 10,
            startupMode = StartupMode.COLD,
            setupBlock = { pressHome() },
            measureBlock = { startActivityAndWait {} }
        )

    companion object {
        private const val PACKAGE_NAME =
            "androidx.benchmark.integration.baselineprofile.flavors.consumer.free"
        private const val ACTION =
            "androidx.benchmark.integration.baselineprofile.flavors.consumer.free.EMPTY_ACTIVITY"
    }
}
