/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.extensions.impl.advanced;

import android.annotation.SuppressLint;
import android.util.Size;
import android.view.Surface;
import androidx.camera.extensions.impl.advanced.Camera2OutputConfigImpl;
import androidx.camera.extensions.impl.advanced.ImageReaderOutputConfigImpl;
import androidx.camera.extensions.impl.advanced.MultiResolutionImageReaderOutputConfigImpl;
import androidx.camera.extensions.impl.advanced.SurfaceOutputConfigImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

@SuppressLint(value={"UnknownNullness"})
public class Camera2OutputConfigImplBuilder {
    static AtomicInteger sLastId = new AtomicInteger(0);
    private OutputConfigImplImpl mOutputConfig;
    private int mSurfaceGroupId;
    private String mPhysicalCameraId;
    private List<Camera2OutputConfigImpl> mSurfaceSharingConfigs;

    private Camera2OutputConfigImplBuilder(OutputConfigImplImpl outputConfig) {
        this.mOutputConfig = outputConfig;
    }

    private int getNextId() {
        return sLastId.getAndIncrement();
    }

    public static Camera2OutputConfigImplBuilder newImageReaderConfig(Size size, int imageFormat, int maxImages) {
        return new Camera2OutputConfigImplBuilder(new ImageReaderOutputConfigImplImpl(size, imageFormat, maxImages));
    }

    public static Camera2OutputConfigImplBuilder newMultiResolutionImageReaderConfig(int imageFormat, int maxImages) {
        return new Camera2OutputConfigImplBuilder(new MultiResolutionImageReaderOutputConfigImplImpl(imageFormat, maxImages));
    }

    public static Camera2OutputConfigImplBuilder newSurfaceConfig(Surface surface) {
        return new Camera2OutputConfigImplBuilder(new SurfaceOutputConfigImplImpl(surface));
    }

    public Camera2OutputConfigImplBuilder addSurfaceSharingOutputConfig(Camera2OutputConfigImpl camera2OutputConfig) {
        if (this.mSurfaceSharingConfigs == null) {
            this.mSurfaceSharingConfigs = new ArrayList<Camera2OutputConfigImpl>();
        }
        this.mSurfaceSharingConfigs.add(camera2OutputConfig);
        return this;
    }

    public Camera2OutputConfigImplBuilder setPhysicalCameraId(String physicalCameraId) {
        this.mPhysicalCameraId = physicalCameraId;
        return this;
    }

    public Camera2OutputConfigImplBuilder setSurfaceGroupId(int surfaceGroupId) {
        this.mSurfaceGroupId = surfaceGroupId;
        return this;
    }

    public Camera2OutputConfigImpl build() {
        this.mOutputConfig.setId(this.getNextId());
        this.mOutputConfig.setPhysicalCameraId(this.mPhysicalCameraId);
        this.mOutputConfig.setSurfaceGroup(this.mSurfaceGroupId);
        this.mOutputConfig.setSurfaceSharingConfigs(this.mSurfaceSharingConfigs);
        return this.mOutputConfig;
    }

    private static class MultiResolutionImageReaderOutputConfigImplImpl
    extends OutputConfigImplImpl
    implements MultiResolutionImageReaderOutputConfigImpl {
        private int mImageFormat;
        private int mMaxImages;

        MultiResolutionImageReaderOutputConfigImplImpl(int imageFormat, int maxImages) {
            this.mImageFormat = imageFormat;
            this.mMaxImages = maxImages;
        }

        @Override
        public int getImageFormat() {
            return this.mImageFormat;
        }

        @Override
        public int getMaxImages() {
            return this.mMaxImages;
        }
    }

    private static class ImageReaderOutputConfigImplImpl
    extends OutputConfigImplImpl
    implements ImageReaderOutputConfigImpl {
        private Size mSize;
        private int mImageFormat;
        private int mMaxImages;

        ImageReaderOutputConfigImplImpl(Size size, int imageFormat, int maxImages) {
            this.mSize = size;
            this.mImageFormat = imageFormat;
            this.mMaxImages = maxImages;
        }

        @Override
        public Size getSize() {
            return this.mSize;
        }

        @Override
        public int getImageFormat() {
            return this.mImageFormat;
        }

        @Override
        public int getMaxImages() {
            return this.mMaxImages;
        }
    }

    private static class SurfaceOutputConfigImplImpl
    extends OutputConfigImplImpl
    implements SurfaceOutputConfigImpl {
        private Surface mSurface;

        SurfaceOutputConfigImplImpl(Surface surface) {
            this.mSurface = surface;
        }

        @Override
        public Surface getSurface() {
            return this.mSurface;
        }
    }

    private static class OutputConfigImplImpl
    implements Camera2OutputConfigImpl {
        private int mId = -1;
        private int mSurfaceGroup = 0;
        private String mPhysicalCameraId = null;
        private List<Camera2OutputConfigImpl> mSurfaceSharingConfigs = null;

        OutputConfigImplImpl() {
        }

        @Override
        public int getId() {
            return this.mId;
        }

        @Override
        public int getSurfaceGroupId() {
            return this.mSurfaceGroup;
        }

        @Override
        public String getPhysicalCameraId() {
            return this.mPhysicalCameraId;
        }

        @Override
        public List<Camera2OutputConfigImpl> getSurfaceSharingOutputConfigs() {
            return this.mSurfaceSharingConfigs;
        }

        public void setId(int id) {
            this.mId = id;
        }

        public void setSurfaceGroup(int surfaceGroup) {
            this.mSurfaceGroup = surfaceGroup;
        }

        public void setPhysicalCameraId(String physicalCameraId) {
            this.mPhysicalCameraId = physicalCameraId;
        }

        public void setSurfaceSharingConfigs(List<Camera2OutputConfigImpl> surfaceSharingConfigs) {
            this.mSurfaceSharingConfigs = surfaceSharingConfigs;
        }
    }
}

