/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.foundation.text

import androidx.compose.ui.text.input.ImeAction
import androidx.compose.ui.text.input.ImeOptions
import androidx.compose.ui.text.input.KeyboardCapitalization
import androidx.compose.ui.text.input.KeyboardType
import androidx.compose.ui.text.input.PlatformImeOptions
import com.google.common.truth.Truth.assertThat
import org.junit.Test
import org.junit.runner.RunWith
import org.junit.runners.JUnit4

@RunWith(JUnit4::class)
class KeyboardOptionsTest {

    @Test
    fun test_toImeOption() {
        val platformImeOptions = PlatformImeOptions("privateImeOptions")

        val keyboardOptions = KeyboardOptions(
            keyboardType = KeyboardType.Number,
            imeAction = ImeAction.Go,
            capitalization = KeyboardCapitalization.Sentences,
            autoCorrect = false,
            platformImeOptions = platformImeOptions
        )

        assertThat(keyboardOptions.toImeOptions(singleLine = true)).isEqualTo(
            ImeOptions(
                keyboardType = KeyboardType.Number,
                imeAction = ImeAction.Go,
                capitalization = KeyboardCapitalization.Sentences,
                autoCorrect = false,
                singleLine = true,
                platformImeOptions = platformImeOptions
            )
        )
    }
}
