/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.generator

/**
 * List of 'core' icons that will be added to the 'core' icons module, and depended on by
 * material. These icons are the set of most commonly used icons, including icons used by
 * Material components directly (such as the menu icon in an AppBar). All icons not specified
 * here will be generated to the 'extended' icons module.
 */
val CoreIcons = listOf(
    "AccountBox",
    "AccountCircle",
    "Add",
    "AddCircle",
    "ArrowBack",
    "ArrowDropDown",
    "ArrowForward",
    "Build",
    "Call",
    "Check",
    "CheckCircle",
    "Clear",
    "Close",
    "Create",
    "DateRange",
    "Delete",
    "Done",
    "Email",
    "ExitToApp",
    "Edit",
    "Face",
    "Favorite",
    "FavoriteBorder",
    "Home",
    "Info",
    "KeyboardArrowDown",
    "KeyboardArrowLeft",
    "KeyboardArrowRight",
    "KeyboardArrowUp",
    "List",
    "LocationOn",
    "Lock",
    "MailOutline",
    "Menu",
    "MoreVert",
    "Notifications",
    "Person",
    "Phone",
    "Place",
    "PlayArrow",
    "Refresh",
    "Search",
    "Send",
    "Settings",
    "Share",
    "ShoppingCart",
    "Star",
    "ThumbUp",
    "Warning"
)
