/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.window.testing.embedding

import androidx.window.core.ExperimentalWindowApi
import androidx.window.embedding.SplitAttributes
import org.junit.Assert.assertEquals
import org.junit.Test
import org.mockito.kotlin.mock

/** Test class to verify [TestSplitInfo] */
@OptIn(ExperimentalWindowApi::class)
class SplitInfoTestingTest {

    /** Verifies the default value of [TestSplitInfo]. */
    @Test
    fun testSplitInfoDefaultValue() {
        val splitInfo = TestSplitInfo()

        assertEquals(TestActivityStack(), splitInfo.primaryActivityStack)
        assertEquals(TestActivityStack(), splitInfo.secondaryActivityStack)
        assertEquals(
            SplitAttributes.Builder()
                .setSplitType(SplitAttributes.SplitType.SPLIT_TYPE_EQUAL)
                .setLayoutDirection(SplitAttributes.LayoutDirection.LOCALE)
                .build(),
            splitInfo.splitAttributes)
    }

    /** Verifies [TestSplitInfo] */
    @Test
    fun testSplitInfoWithNonEmptyActivityStacks() {
        val primaryActivityStack = TestActivityStack(listOf(mock()), isEmpty = false)
        val secondaryActivityStack = TestActivityStack(listOf(mock()), isEmpty = false)
        val splitAttributes = SplitAttributes.Builder()
            .setSplitType(SplitAttributes.SplitType.SPLIT_TYPE_HINGE)
            .setLayoutDirection(SplitAttributes.LayoutDirection.TOP_TO_BOTTOM)
            .build()

        val splitInfo = TestSplitInfo(primaryActivityStack, secondaryActivityStack, splitAttributes)

        assertEquals(primaryActivityStack, splitInfo.primaryActivityStack)
        assertEquals(secondaryActivityStack, splitInfo.secondaryActivityStack)
        assertEquals(splitAttributes, splitInfo.splitAttributes)
    }
}
