/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.appactions.interaction.service;

import androidx.appactions.interaction.capabilities.core.impl.ErrorStatusInternal;

/** Exception that occurs from failure to execute capability when sending fulfillment request. */
final class CapabilityExecutionException extends RuntimeException {

    private final ErrorStatusInternal mErrorStatus;

    CapabilityExecutionException(ErrorStatusInternal mErrorStatus, String message) {
        super(message);
        this.mErrorStatus = mErrorStatus;
    }

    ErrorStatusInternal getErrorStatus() {
        return this.mErrorStatus;
    }
}
