/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

@file:RestrictTo(RestrictTo.Scope.LIBRARY)

package androidx.privacysandbox.sdkruntime.client.config

import androidx.annotation.RestrictTo
import org.xmlpull.v1.XmlPullParser
import org.xmlpull.v1.XmlPullParser.END_TAG
import org.xmlpull.v1.XmlPullParser.START_TAG

/**
 * Skip current tag (including inner tags)
 *
 * @suppress
 */
internal fun XmlPullParser.skipCurrentTag() {
    require(START_TAG, null, null)
    var depth = 1
    while (depth != 0) {
        when (next()) {
            END_TAG -> depth--
            START_TAG -> depth++
        }
    }
}
