/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.privacysandbox.tools.internal

import androidx.annotation.RestrictTo

/**
 * Indicates that a class was generated by the API Compiler and is part of the public facing
 * SDK API.
 *
 * The API Packager will include these classes in the API descriptors.
 *
 * THIS ANNOTATION IS FOR INTERNAL USAGE ONLY.
 *
 * @suppress
 */
@Retention(AnnotationRetention.BINARY)
@Target(AnnotationTarget.CLASS)
@RestrictTo(RestrictTo.Scope.LIBRARY_GROUP)
public annotation class GeneratedPublicApi