/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package androidx.room.integration.kotlintestapp.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Query
import androidx.room.Update
import androidx.room.integration.kotlintestapp.vo.Toy

@JvmDefaultWithCompatibility
@Dao
interface ToyDao {
    @Insert
    fun insert(vararg toys: Toy)

    @Query("SELECT * FROM Toy WHERE mId = :id")
    fun getToy(id: Int): Toy?

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    fun insertOrReplace(toy: Toy)

    @Insert(onConflict = OnConflictStrategy.IGNORE)
    fun insertOrIgnore(toy: Toy)

    @Update(onConflict = OnConflictStrategy.REPLACE)
    fun updateOrReplace(toy: Toy): Int

    @Update(onConflict = OnConflictStrategy.IGNORE)
    fun updateOrIgnore(toy: Toy): Int
}