/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.room.vo

import androidx.room.compiler.processing.XMethodElement
import androidx.room.compiler.processing.XType
import androidx.room.solver.transaction.binder.TransactionMethodBinder

class TransactionMethod(
    val element: XMethodElement,
    val returnType: XType,
    val parameterNames: List<String>,
    val callType: CallType,
    val methodBinder: TransactionMethodBinder
) {
    enum class CallType {
        /**
         * Directly call the method, it has an implementation
         */
        CONCRETE,

        /**
         * It has a default implementation and the default implementation is in the DAO
         */
        DEFAULT_JAVA8,

        /**
         * Has DefaultImpl generated by kotlin
         */
        DEFAULT_KOTLIN,

        /**
         * It has a default implementation which is not declared in the dao, rather, it inherits
         * it from a super.
         */
        INHERITED_DEFAULT_JAVA8
    }
}
