% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapseSeqs.R
\name{collapseSeqs}
\alias{collapseSeqs}
\title{Collapse Overlapping Sequences}
\usage{
collapseSeqs(packMatches, Genome)
}
\arguments{
\item{packMatches}{A dataframe containing genomic ranges and names referring 
to sequences to be extracted. This dataframe is in the format 
produced by coercing a 
\code{link[GenomicRanges:GRanges-class]{GRanges}} 
object to a dataframe: \code{data.frame(GRanges)}. 

Must contain the following features:
\itemize{
    \item start - the predicted element's start base 
    sequence position.
    \item end - the predicted element's end base 
    sequence position.
    \item seqnames - character string referring to the 
    sequence name in \code{Genome} to which \code{start} 
    and \code{end} refer to.
}}

\item{Genome}{A DNAStringSet object containing sequences referred to 
in \code{packMatches} (the object originally used to 
predict the transposons \code{\link{packSearch}}).}
}
\value{
A set of non-overlapping transposon sequences in the format
of the input dataframe.
}
\description{
The sequences predicted by \code{\link{packSearch}} often 
overlap, which may be due to the presence of closely 
interspersed elements or false TIR identification. 
In such cases, these elements can be combined using 
\code{link[GenomicRanges:GRanges-class]{GRanges}} 
in order to collapse overlapping elements, preventing 
over-estimation of transposon numbers. Also removes 
duplicate elements that have been generated in the 
case of multiple searches.
}
\examples{
data(packMatches)
data(arabidopsisThalianaRefseq)

packMatches$start <- 1
packMatches$end <- 10

collapseSeqs(packMatches, arabidopsisThalianaRefseq)

}
\seealso{
\code{\link{packSearch}},
\code{link[GenomicRanges:GRanges-class]{GRanges}}
}
\author{
Jack Gisby
}
