
\name{zebrafish_dbconn}

\alias{zebrafish_dbconn}
\alias{zebrafish_dbfile}
\alias{zebrafish_dbschema}
\alias{zebrafish_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  zebrafish_dbconn()
  zebrafish_dbfile()
  zebrafish_dbschema(file="", show.indices=FALSE)
  zebrafish_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{zebrafish_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{zebrafish_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{zebrafish_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{zebrafish_dbschema} prints the schema definition of the
  package annotation DB.

  \code{zebrafish_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{zebrafish_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{zebrafish_dbfile}: a character string with the path to the
  package annotation DB.

  \code{zebrafish_dbschema}: none (invisible \code{NULL}).

  \code{zebrafish_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  library(DBI)
  ## Count the number of rows in the "probes" table:
  dbGetQuery(zebrafish_dbconn(), "SELECT COUNT(*) FROM probes")

  zebrafish_dbschema()

  zebrafish_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

