/*
All of the code within the ZingChart software is developed and copyrighted by ZingChart, Inc., and may not be copied,
replicated, or used in any other software or application without prior permission from ZingChart. All usage must coincide with the
ZingChart End User License Agreement which can be requested by email at support@zingchart.com.

Build 2.9.16-hf1
*/
zingchart.setModule("patterns"),ZC.PATTERNS={BACKWARD_DIAGONAL:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAHBJREFUWEftlrENwCAMBFnC+4/i0Qi2RJSARIe/OSQaKP4w+ERz9z5GW2esm1m/vb8FB0hVeOTITj4r+wOoPPm88hdAER4QCaAKTwBleAJUtNqplbMCeOBbgeo3gQfwAB7gP4AH8AAewAN4AA/IPfAATxdUJnK80toAAAAASUVORK5CYII=",DARK_DOWNWARD_DIAGONAL:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAFVJREFUWEft1E0OABAMhNG5/6Vpx0YcoLPwSQir/nhI0upZo5faDp8jQa8iXXUyCbc8nMTwnb/Gku137HD7z7MLJ4EB/gEMYAADGMAABjCAAQx8bmADVA34alCX0tkAAAAASUVORK5CYII=",DARK_HORIZONTAL:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAFFJREFUWEft1MENACAMw8Dsv3RQWeI+QeobI5smSfFggLaRQy+/h99ZA1QDvXwN/A8gd8BXwAG2B7gCDrAGuAIOsAa4Ag6wBrgCDrAGuAIN8AA57/hqbkOtzwAAAABJRU5ErkJggg==",DARK_UPWARD_DIAGONAL:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAF1JREFUWEftlcENACAIA9l/aQSiiTpA+zkTjb4a4GwjM6N3rT7qqn1bxXfhnsqvTuvb/oxZPfNfDwbm+1nHYBVv73GaED4w9g8DrhQkC07n8QGyAAZgAAZgAAbsDCxUDfhqlv7F7QAAAABJRU5ErkJggg==",DARK_VERTICAL:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAADpJREFUWEft0MENAEAEBMDtv+nDVwE+NxLCC5Mkb7JjSrfn8/nC/bADCBAgQIAAAQIECBAgQIDA5wIFYx34aoQeqCkAAAAASUVORK5CYII=",DASHED_DOWNWARD_DIAGONAL:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAFxJREFUWEftllEKACAIQ73/pS1Dii7g+3mBRF/OtQ0jM4MstHkNXmffj4Xxd6PAQNwvGJ+8mf80QIDgRUha8OhPAITwvtwxB9AY3h7QBTLgPuA+oAtkwBwwB3TBAglP9Zc0Ns1HAAAAAElFTkSuQmCC",DASHED_HORIZONTAL:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAG1JREFUWEftlaEWACAIA/f/P43PhhpMHIQFgs8w3A6UpMgVEcpVfn8L0ufjtbT41pvXQHnmF3PzHKA56HeAzvzZM7TlbuDrAM1E/xQYQjrzL4R0JIbwcYBmwhH0O0Bn7j0w3wGaif4poD+fcQwsP4D1l01+GdYAAAAASUVORK5CYII=",DASHED_UPWARD_DIAGONAL:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAGhJREFUWEftljEOACAIA/n/pzESxRCdOYcODkwtF1s1dzfyoOJz8WLAYjxEOuY00CH2Wi4MUOJLux97IUEm4LqEhJm/YogTINKgHkBLSDEUAf0HkgDRgLv21QN6jv8iQKRB/wH1AJ6CAQlP9Zf4V0qcAAAAAElFTkSuQmCC",DASHED_VERTICAL:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAE1JREFUWEftlDEOACAIxO7/nxYdQeZjoCawOEjKVUk697zWluGeAYYJ1N0bdp4y9wWPAewE3A82mRu2AAL8AxDAAghgAQSwAAJYsJ5AAA719ZdxH+JTAAAAAElFTkSuQmCC",DIAGONAL_BRICK:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAGxJREFUWEftlDEOwDAIA/n/p4mIGhQptJ1MlhsyOcIGxJm729szC0mrXzWP5soAHZ2vyR4BOs2PCYT5VwCFnhPYjasQKn0G6DTM3T8XVprvn+QrUd/5X304AAfgAByAA3AADsABOAAH4MB1DgyYgHYXfCgvqQAAAABJRU5ErkJggg==",DIAGONAL_CROSS:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAABp0RVh0U29mdHdhcmUAUGFpbnQuTkVUIHYzLjUuMTAw9HKhAAAAcElEQVRYR+2VuQ0AMQgEaYL+S6E0PyfdCTkhWnPBWHLCSrxmbO4+ImKsY/lu29bUur2BchLZptafqm8GPAv62n6r5edI/5FA6wjUj6zyb+o1q/z3J1C1SK3DATjQ/xlVe6rW4QAcgANwAA7AATgAByaWNpQXni2HuAAAAABJRU5ErkJggg==",DIVOT:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAHlJREFUWEftl8EOABAMQ/f/Pz0cJEw4WddDDw4iMXvrCnN3qxxbcLMxvR8oY/3IPiPImlTcn48AWg+dCL7uW0nQoot64CaA0ANfF6BFyUcAUffQCfIBYgIIPfB1gXwAUXf5wCQw9Kb3gHyAj4B84PWPi3R+3BvlPtAAt181ZiOa/AsAAAAASUVORK5CYII=",DOTTED_DIAMOND:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAH5JREFUWEftVkEKACAI8/+frjzUQbMuOYUMCkTItqlJRNTG4mO73f2n4AjfQi2RomyTegR6jqEe4K65yLk8DKA0n9LOePEMoDWXyR3PgNQEbedhwEKuNHv8d+RhoPpAzQP/5oB3nd/urz4Qz0DNA+j/P99MeKtTb398FXyfAx3yrjVmkjfS9gAAAABJRU5ErkJggg==",DOTTED_GRID:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAFNJREFUWEftlDEKACAMA/P/T2vF6taxRPAE6VBQc42RpBEriqmuy537Kq8ecci09Z3qc/R79m0K01vl+RB4hgA5wC+AAATIATwAAQiQA3gAAt8SmDndFYZ8cOIZAAAAAElFTkSuQmCC",FORWARD_DIAGONAL:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAGtJREFUWEftlEEOQBEMRHuJ3v8oPRq/FoKfsGI2T2KjCdMxfebuJSLKt2zdeX67bi8e2TXRulaK6LarREz/rhAhCd6YiZ+A15loAVSNYDpht+f8dL90BNN5OAAH4AAcgANwAA7AATgAB+BABU8XVCZ02jm4AAAAAElFTkSuQmCC",HORIZONTAL:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAENJREFUWEft1LERACAMAzHvv7Q5WMIFKlJDdPBJ0um0zXKmh9/FXYDAXmDagNugZQN8QwIEnoAOCBEBAjrgDRD4XuAAMnH1lw3iRikAAAAASUVORK5CYII=",HORIZONTAL_BRICK:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAABp0RVh0U29mdHdhcmUAUGFpbnQuTkVUIHYzLjUuMTAw9HKhAAAAaElEQVRYR+2VOw7AIAxDff9LhyImaFWm8CJhpLAwYPxDkgIexbP69jkdXPJ5+gW7BxQAgHpg1feA5pMkL+PdBwDVf3RQgRQkF4174P+vcQ/gDLgHXES4B/AUGADuAcewBAOoDxxDmoEG1/c3SEI8zEQAAAAASUVORK5CYII=",HOUNDSTOOTH:"data:image/png;base64,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",LARGE_CHECKER_BOARD:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAE5JREFUWEftlCEOADAIA/v/T3eZg2S6FTuBwjRHD0nyHNuaE9gToEygcPPVuVW4GyZQOgJsAmnkj86VLYAAfwACWAABLIAAFkAAC74ncABUDfhq/74CqwAAAABJRU5ErkJggg==",LARGE_GRID:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAElJREFUWEftlMEKACAIxfb/P215Dzo9KpqgFw/qkAHU4aRmdFlmLxfuxwfsDnABCVxAQA+ERaMHJPAAAT2gByQgAT3gD0jgawIDjp4WdwgcEJMAAAAASUVORK5CYII=",LIGHT_DOWNWARD_DIAGONAL:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAFVJREFUWEft1UEKACAIRNG5/6VLoyQ8gLP5QUGrtB6TJK0YuZw5vrcc+jXt6/wWUQW4bmL+zbs5V+eF3qYfAy93MGCN4YBIDvAXYAADGMAABjCAAQxsIjn2iEwKz6cAAAAASUVORK5CYII=",LIGHT_HORIZONTAL:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAE5JREFUWEft0rERADAIw0Dvv7RzTPEpXFAjkJKkdNpGDl1+h3sA6v/6k/7/UMA/sAa4Ag6wBrgCDrAGuAIOsAa4Ag6wBrgCDrAGuAIN8ACOm/aI0dUi9wAAAABJRU5ErkJggg==",LIGHT_UPWARD_DIAGONAL:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAFJJREFUWEft1MENACAIQ9HuvzQGE406QHvwH0z0hMADVZXWkfrqfUeDd7LzA4nMj6r7y3612d3zNx4GogD3FLAH2AMYwAAGMIABDGAAAxj42sAAIjn2iJSofAQAAAAASUVORK5CYII=",LIGHT_VERTICAL:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAADRJREFUWEft0MkJAAAIA7Duv7TXEn4iVOivJElqbt/loRtAgAABAgQIECBAgAABAgQI/Ao0LYX2iO73c+wAAAAASUVORK5CYII=",NARROW_HORIZONTAL:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAADJJREFUWEft0DEBAAAIw7D5Nz1wwUGOCmiSpKe1zWU7T4AAAQIECBAgQIAAAQIECDwXGEb++GpEBZhgAAAAAElFTkSuQmCC",NARROW_VERTICAL:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAADNJREFUWEft0LENAAAIAjD/fxrxCpeyMEI6SaZp/fQtO0CAAAECBAgQIECAAAECBAi8CixMhfhq+ZRKggAAAABJRU5ErkJggg==",OUTLINED_DIAMOND:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAABp0RVh0U29mdHdhcmUAUGFpbnQuTkVUIHYzLjUuMTAw9HKhAAAAiklEQVRYR+2W4QqAQAiDff+XrvxxUeYRBzkHLSi4IsRvQ2dmth2XP273eF/+3QvHIsjz2TWs40A8xZ5JkpGaybbyPwcBpOaR5MOAAx/MEzO9qjS/1vMmOQi0egCuueZARqDVA+Xb7m3bag4oD8TZjPaE8gDHNlzJcF97hoNA6y5QHqAg0OqB3+eBHerpNldZ2kG2AAAAAElFTkSuQmCC",PLAID:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAGhJREFUWEftlsEKACAIQ/3/ny4lLC/digW9QDoITZeTmZk1P36Jbim4N63rPBl/goH4/4woqEbN5Zwczi/wSwCzuc37FCDS/1MqkEpRCp6bkD0AA9JBlILjB9gDwwzjB/ADMIAKPmegA2Md+Gpq/jrnAAAAAElFTkSuQmCC",POLKA_DOTS:"data:image/png;base64,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",SHADE_25:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAABp0RVh0U29mdHdhcmUAUGFpbnQuTkVUIHYzLjUuMTAw9HKhAAAAPklEQVRYR+3QyQkAQAgDwPTf9F7sywL0M4JCXpJJknXmnrfteezxL97fuIoTIECAAAECBAgQIECAAAEC0wIbJf32iBmvpbwAAAAASUVORK5CYII=",SHADE_50:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAADhJREFUWEft0KERADAQAjD2X7rF/AyYYJAcSZLXtEY9He/p3fMTJ0CAAAECBAgQIECAAAECBNYCH1QN+GrBAjo6AAAAAElFTkSuQmCC",SHADE_75:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAFRJREFUWEft1EESABAIheHuf+nIQs8Feha/GSYrqo/IzNijljOn98/hepHB2JO5VLrLP5j1bXk1HQMW/RgQ8OZX4PoBMYABDGAAAxjAAAYwgIFvDCzgKfs9OLGfXQAAAABJRU5ErkJggg==",SHINGLE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAG5JREFUWEftlDEOACEIBPf/n0ZtjEHRWMhdMQWNRFlgHZmZViHJWrzO1xpzkfHseb51mFrQNdzHnzVyv9Jp/9lClgb0a4lMGhn05n4o4OaR3U85ifyvgCwvwAE4AAfgAByAA3AADsABOAAHPudAARVYVjfJqHWiAAAAAElFTkSuQmCC",SMALL_CHECKER_BOARD:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAEpJREFUWEft0ikOACAMBMD9/6c5EjDgWzOIhqpekyRjvR3WNzvU5m2Fz6B9k98Gylf+n7j45m8DDDDAAAMMMMAAAwwwwAADDHQbmFQN+GpahxltAAAAAElFTkSuQmCC",SMALL_GRID:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAEpJREFUWEft1EEOADAERNG5/6UpSwcYkn4JSVcleUhSLKfiRZXOasb8tn84BzzQAAbM6DAw786BLcAAdwADGMAABjCAAQxg4GsDCSFid/mPw2MlAAAAAElFTkSuQmCC",SOLID_DIAMOND:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwgAADsIBFShKgAAAABp0RVh0U29mdHdhcmUAUGFpbnQuTkVUIHYzLjUuMTAw9HKhAAAAhElEQVRYR+1XQQrAMAjz/592dMzNDTs8NMsOORQsKUbEBGvubnHMRnjdnzECv5EPghlJYKvxvYCcvCoCiZfkuYiKfClO70AeQNoM/EIFb/JDYqcMYxbkA/KBzzsgH0BqvJNbPqB9gN8B+UBHq8g38gG+CuB7//Hbmn1u+B2QDyA13sm9AfHk15mlZfVdAAAAAElFTkSuQmCC",SPHERE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAIhJREFUWEftlsEKwCAMQ/3/n+6m4Faru4hLc4igUHposOnTYmblXvVoGx234rVo3z72on7MzwL8jawEHs4nC0D3PNYbPADqefTcOwFfAg73nEwAlQe6GD/zAE4kjyEANBNpB1NTeUAcSAERlQfEgcVT+XzTIh3jN247T+UBcUAcEAfEAXEggwMXV1Y5KqvA15MAAAAASUVORK5CYII=",TRELLIS:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAFJJREFUWEftlDEKACAMxO7/n64UUcQHNEsGoU7XhnBJUuir6vy9RM/T/xsOUmAuf0jrAEyAsl8HDnl7gCcw3f1/Hk/AHtABHdABHdABHdAB2oEF/1L6TO6omnoAAAAASUVORK5CYII=",VERTICAL:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAADZJREFUWEft0CEOADAIA8D+/9MMPHqYIymmprkkqb55az70BhAgQIAAAQIECBAgQIAAAQK3Ag8WffWXRf+jwwAAAABJRU5ErkJggg==",WAVE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAFhJREFUWEft0kEKACAIRNG5/6UNhUKhdpWbvwgiISd7MjN1rtJckvk6BXpRXwFy47nfnXm4m/W47Per84Rb/z+mWdI0TAMDGMAABjCAAQxgAAMYwAAGMDAAlAk2V/DjUmEAAAAASUVORK5CYII=",WEAVE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAJBJREFUWEftl8EOwCAIQ/n/n3bTjGRpZF5W6AETTZSDWp4gZmbjbnNYPX3+3tQ3jw7BsNfd/FH+U3bGjVHxfJ8jczsAkQEE9E+7FgOZ9DsLGgwg7ZlKaDEQ0c5URIMB5js/xRktBpi+jlK9BgMdByp8r5ULOg5k/P06Duzqj7VWVhF1XeC16Clfs+1aDFTkhAu0ppboa2rAWgAAAABJRU5ErkJggg==",WIDE_DOWNWARD_DIAGONAL:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAHxJREFUWEftlsEOwCAIQ/n/n56igYVsHuVdaoIXEilYCmZmj9s8fhUL32X/BnA5yPl9z7op018QWXIKBPHnpRIU8RLEB0A3JxYBwRZ8OwAEIR3Y8isdCBJ2V0I6kOSTDlBLifYB7QPaB7ApmLOHHMUrNjUFSwVIENIBXAcGOyP3eYNY1XwAAAAASUVORK5CYII=",WIDE_UPWARD_DIAGONAL:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAIJJREFUWEftl0sKwCAMRHP/S7eaatF+oBvnLTqCLhRMnMRnjIjYSqvD1Ot870vXl27+4XDcyZtzjOyDMqcDsphfwpIOUMabbVG2vyfk4QB4G1DjdwCpc8IcMAdQCE0gMgdGBZRvgzlgDpgDqQAIIdcDqT96FVHj+Rqqa8CHT/DP/wU7OyP3ec2snc0AAAAASUVORK5CYII=",ZIGZAG:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAadEVYdFNvZnR3YXJlAFBhaW50Lk5FVCB2My41LjEwMPRyoQAAAF5JREFUWEftlDEOACAIA/n/p1USNYisdDoTHexQqQdmZmMtP77tWrvuxpVJvOvUb9Uqw1zwE7sk8vTlZfyHB8mDYCC2nyRyGNgD77Q9c4A5AAMwAAMwAAMwAAMwAAMTIjn2iP6kzQIAAAAASUVORK5CYII=",BACKWARD_DIAGONAL_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAAO0lEQVRYhe3QsQ0AQAzCQPZfmt8g6fKF7ZbiJJKhtv22i4uLX+1j3GfExTn4FvcZcXEOvsV9Rlycgyd54RD+EIG1e0QAAAAASUVORK5CYII=",DARK_DOWNWARD_DIAGONAL_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAASklEQVRYhe3SKw4AIAwE0dn7HxoMopKET83UDaIQ8hhrWPO7Wy6tnXoIkCQ/m92XvurW7+fWkpPWgAY0oAENaEADGtCABjSgAQ1MPej6Q6bDvyIAAAAASUVORK5CYII=",DARK_HORIZONTAL_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAAL0lEQVRYhe3SMQEAMAzDsHT8Oacwekwi4MfTtjn0LuMkyXjgex7AA3gAD+ABPMACwL8f+X9qgmoAAAAASUVORK5CYII=",DARK_UPWARD_DIAGONAL_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAAUElEQVRYhe3SMQ4AIAxCUbj/oXExxvQAZfluuNA2z7ovSSTJtjfzK/8/VnO1fJ6iMYznIBjYzhiobf5ytXyeojEMBjCAAQxgAAMYwAAGMHAAGrj6Q+IMjOoAAAAASUVORK5CYII=",DARK_VERTICAL_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAAL0lEQVRYhe3OoREAAAjEsD/23xkMM4BJXV3SW7brrzwHAAAAAAAAAAAAAAAAAAAwJpk//xI2cj0AAAAASUVORK5CYII=",DASHED_DOWNWARD_DIAGONAL_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAAOElEQVRYhe3SsQ0AMBCDwN9/aWeMIMF17ih8p7dtP3cRvIj4II5XBCoiPojjFYGKiA/ieEWgInQe4RD+EMV+86UAAAAASUVORK5CYII=",DASHED_HORIZONTAL_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAAOUlEQVRYhe3UMQ4AIAgEQe//j8aWxFopnOkIJWRTVbWaJOnz7T3jjnu8/gnGRQe+pwPoADqADqADbNodf/mqcAKsAAAAAElFTkSuQmCC",DASHED_UPWARD_DIAGONAL_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAANUlEQVRYhe3ToQEAQAzCQPZfmrf9LlCRnENFkWho27Nt/GpLH+4buHFp476BG5c27hu4cSV54RD+EDKFK+cAAAAASUVORK5CYII=",DASHED_VERTICAL_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAASElEQVRYhe2UsQ0AMAjDUP//Od0bia1hwF5ZLEAuSaqG3/PTDRMgYKR/YnwDCMRv/jK+AQQMOrBOgA4gYNCBdQJ0AAGDDqwTuCmHf7HhqguaAAAAAElFTkSuQmCC",DIAGONAL_BRICK_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAAW0lEQVRYhe2UMQoAMAgDS///53TpkKFKFw20ccwJB4IZIxkAkHHLu/hUykN4Wizl7ULOsrNgTyWP2NXCU9/wr9w9oBFy5h6wXC13D2iEnLkHLFfL3QMaIWfqHlj6wr1nKG9l2QAAAABJRU5ErkJggg==",DIAGONAL_CROSS_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAAYElEQVRYhe2UMQoAIAwDi///c1wcarGjiWAyBU4Qar0AgGiClZt8LydI4PQL26kwRl756A7TI30C6RKqv+EbO2APZGAP1E7h9oA89kAG9kDtFG4PyGMPZGAP1E7hX3tgAgJtHRz1EltEAAAAAElFTkSuQmCC",DIVOT_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAASElEQVRYhe2UsQ0AAAiD/P/p+gWSWFYXy8CMiSS5vN8/oTCAo16NPKc2gKOw0Q7gqFe3AzgKG+0Ajnp1O4CjsNEO4KhXv+jAAkQwfpBzDFvPAAAAAElFTkSuQmCC",DOTTED_DIAMOND_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAASUlEQVRYheXSMQoAIBADwfv/p2Ofwk45mO3E5iAzSTKXXv/vqS/9/d6Ta8I14G7euQY614RrwN28cw10rgnXgLt55xroXBOsgQPNg36QncnaogAAAABJRU5ErkJggg==",DOTTED_GRID_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAAPUlEQVRYhe3UoQ0AMAwDsPz/dHbC0BQwlxSUVFaUtG2SrPZ+bp+8vu+HAAE9IAMECOgBGSBAQA/IAIHvBQ7flL5Q9aXahAAAAABJRU5ErkJggg==",FORWARD_DIAGONAL_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAAO0lEQVRYhe3PoQEAMAgEMfZf+jsBOGoI9gT5SpIabrt/eQIBATH2O0shICC6fmcpBARE1+8shYCAaPoD4RD+EH6WOjwAAAAASUVORK5CYII=",HORIZONTAL_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAAIklEQVRYhe3UAQEAAAgCoPw/2oYII0jbHrAsHoB5HgA8ADy4uA/1zQ4N6QAAAABJRU5ErkJggg==",HORIZONTAL_BRICK_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAAVUlEQVRYhe2UIRIAIAzDGP//c/EVoGhMY2d6t1xGkhbJa8Dv+74dE+ADBnfASTuBvwAfwDvQDtADeAecdiAN70A7QA/gHXDagTS8A+0APYB3wGkH0hyEt5+J+Er1iAAAAABJRU5ErkJggg==",LARGE_CHECKER_BOARD_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAARElEQVRYhe3UIQ4AIAzF0JX73/ljFzxM0DmYeSGkJEm1Aejn2/tVwyOA8+L1nxh/AQHYge8BdkCAHRBgBwTYAQF2QMAGXTuAKV23RqoAAAAASUVORK5CYII=",LARGE_GRID_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAARUlEQVRYhe3UsQ0AMAwCwTj770w2cCr7m6elOQmJSpJD5geY7m9XbkSAABxQ/kBXbkSAABzgD+ATCBCAA/wBfAIBAnDAAxqoT+UP/BWhAAAAAElFTkSuQmCC",LIGHT_DOWNWARD_DIAGONAL_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAAO0lEQVRYhe3SoREAIBADwfTfdBAYaIAXLC6K/ZlL2+Z4r/fIpxDX/vdyiGgAQgMQGoDQAIQGIDQAsfcCsg/8LjSBs44AAAAASUVORK5CYII=",LIGHT_HORIZONTAL_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAAJklEQVRYhe3SAQEAAAgCoPw/2oYIG0jbHsviwDwHcAAHcAAHcIAHN68f6Spnu2sAAAAASUVORK5CYII=",LIGHT_UPWARD_DIAGONAL_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAARklEQVRYhe3QoQ0AMBDDwOy/9JdWAaUPrmZRgCUnFzMza/vLt3Zep1PClTduCVfeuCVceeOWcOWNW8KVN24JV964JVx5kgOyD/wu91ORvgAAAABJRU5ErkJggg==",LIGHT_VERTICAL_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAAMUlEQVRYhe3OoREAMAwDMV/339mhnSAhevZMadt8bf/LcQAAAAAAAAAAAAAAAAAAAAPVFCAfhi8TBwAAAABJRU5ErkJggg==",NARROW_HORIZONTAL_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAALElEQVRYhe3QAQEAAAgCoPw/2oYIE0jb3rIYMGDAgAEDBgwYMGDAgAED8wMPNY4/0WNRNngAAAAASUVORK5CYII=",NARROW_VERTICAL_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAAL0lEQVRYhe3OMREAMBDDMF/5c05h/CIvXlXVtl39dRwAAAAAAAAAAAAAAAAAAMAHp/s//xtHcHQAAAAASUVORK5CYII=",OUTLINED_DIAMOND_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAAY0lEQVRYhe2UMQ4AMAgC/f+n7dSplcRE0QE2ykIMPXN3t4/ue3f+mgGfatyVx81Y+egFRjew4hdEomxixQXEAdiMlYsDqcaFOZQ4wPKpxuKAOFCdQ4kDLJ9qLA6IA9U5FGMTB9/gfK6IICcEAAAAAElFTkSuQmCC",PLAID_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAASUlEQVRYhe2UsQ0AMAzCTP//ma7tAVU6OEsUZcBCAtoWYGozKd62s+I/OJCLBEiS8379XwyPAKZAB+wBAUyBDtgDApgCHbAHBNgpcjxZtiZCgAAAAABJRU5ErkJggg==",SHADE_25_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAANklEQVRYhe3QsQ0AQAgDMfZfOnSvnwAKnO6qSK4kqW/TvXb8mgABAgQIECBAgAABAgQIEDgv0KqH/C4LpCVQAAAAAElFTkSuQmCC",SHADE_50_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAANUlEQVRYhe3QoQ0AMBDEsNt/6XSMLzAKjORVbdtVdzmvup0TIECAAAECBAgQIECAAAECPwg8VA34aia9F5AAAAAASUVORK5CYII=",SHADE_75_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAAWklEQVRYhe2SsQ0AMAzCoP//nC4R6gUwFDYrC0EmAMzMYEOSVn4hkaMmJN+Di/MLpD4XxxdQkzqwqQNuzi9QB9SkDmzqgJvzC9QBNakDmzrg5vwCdUBNfnXgAsTdYcyCNMP2AAAAAElFTkSuQmCC",SHINGLE_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAAbUlEQVRYhe2UMQrAMAwD5f7/z+7WNhDTKZIGeQqcwQdBKgzT3Q0AVVUn+fvYQQKnH9zxB4yQwD1FlJwmcf1aHJ5RgPYF6YEvsImfjYiS0yTSA+mBZckmfjYiSk6TSA+kB5Ylm/jZiCg5TULeAzfjRr162UNAKwAAAABJRU5ErkJggg==",SMALL_CHECKER_BOARD_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAAQUlEQVRYhe3SsQ0AMQwCQPT778w3yQqhOToqS/jStjnpycs+O3z7l3XWL9gvkDDAAAMMMMAAAwwwwAADDDCwNfADuls8GymxDf0AAAAASUVORK5CYII=",SMALL_GRID_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAAUElEQVRYhe3SIQ4AIAwEQcr//1w8jqRhzNXVTXJb3d1L3g34/e938uxxQKWBd/LscUAa4BNwQBrgE3BAGuATcEAa4BNwQBrgE3BAGuATcMAB18AfGKtfbaAAAAAASUVORK5CYII=",SOLID_DIAMOND_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAAXklEQVRYhe2UMQ4AIAgDuf8/Glcx6IZd2vU6NIRcxJbMzHhkgtNBgLM4xbku20qTnNfZgHGuv0BX+vkD15KC62MPlGX2gD0g4PrYA2WZPWAPCLg+9kBZZg/YAwIuyQK1/r+k58CwYgAAAABJRU5ErkJggg==",SPHERE_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAAXElEQVRYhe2UMQrAMAwDpZL/f1ldstSEbnY7nDYjmww5zpKUJNqx7cn58Xids9PZLx1Sjzr7621xIpZ+xMDEn9d+1aVTOnsYwAMwgAdgAA/AAB6AATwAA3jgcwZuypf+NxzdiPQAAAAASUVORK5CYII=",TRELLIS_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAATklEQVRYhe2SsREAMBCCkv2HNk1YQRu+ks73uEly1pd/C77zBVafw/sFaKIDZB1o834BHaCJDpB1oM37BXSAJjpA1oE27xfQAZroALnND8puPA38nuFuAAAAAElFTkSuQmCC",VERTICAL_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAAMUlEQVRYhe3OoREAAAjEMI79d342wIFKbU0qSWrp+vc2PwIAAAAAAAAAAAAAAAAAABjsGRAvh12sSgAAAABJRU5ErkJggg==",WAVE_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAAV0lEQVRYhe2SMQoAIBDD/P+ndVFwcOgQMEMzHZcp0DFMzM0Xf4tzv364/1qtoxvAqwLvohvAqwLvohvAqwLvohvAqwLvohvAqwLvohvAqwLvohvAqwK/AI2vfK4FSjwJAAAAAElFTkSuQmCC",WEAVE_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAAeUlEQVRYhc3SMQ7AMAgEQf//06RCiiMRur11g4DmLOZUVZ3Xo/tr+K3UHvnpb0//+JorDEzJ0b3CQMSCwgCqfgsR6SO376owMCVH9woDEQsKA6j6LUSkj9y+q8LAlBzdKwxELCgMoOq3EJE+cvuuCgNTcnSvMJCw8ABuN7t9T89nzAAAAABJRU5ErkJggg==",WIDE_DOWNWARD_DIAGONAL_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAAYUlEQVRYhe3UMQoAIQxE0Rnvf+dYCeIuwSax+XbLzxILeY6IkCTb1nFWq+zuWJJ1dyzJum+GKrtvhir7k4e3989A9yXG/vH3U3UfHUuyjgM4gAM4gAM4gAM4gAM4gAPPHZh2OgQyzf2LRgAAAABJRU5ErkJggg==",WIDE_UPWARD_DIAGONAL_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAAX0lEQVRYhe3UMQ6AMAzFUKf3v7OZQKiwkjD8TpVSyVGHV6pVVWxH9bx/OX8MOuOvC7TG9wfdcbj9wET8WmAqDlCTcYA1GVddk3GIA3EgDsSBOBAH4kAciANxIA78wIED3sUEMjMU3n8AAAAASUVORK5CYII=",ZIGZAG_WHITE:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAAWUlEQVRYhe2SIQ4AMAjE+P+nb2aCBZgDTFEkFXeQmiRZMbrTyd8lgwN8PLD8ysTLv5dvFCpL4MAYx4GNQBwI2TjgAQ5kxXCglePARiAOhGwc8AAHsmI40MkPsg/8LlgL9pQAAAAASUVORK5CYII="};