InitialTree=function(y,x,z){ #initial tree
  ET=list()

  ET$n=length(y) #number of samples
  ET$q=ncol(x)   #number of features
  ET$p=ncol(z)   #number of markers

  ET$y=y #outcome
  ET$x=x #features
  ET$z=z #markers

  ET$terminal=1
  ET$internal=NA
  ET$splitVariable=NA
  ET$cutoff=NA

  ET$eta=NA #the number of available values which could be select to split the chosen terminal node
  ET$numNodes=length(ET$terminal)
  ET$marker=sample(1:ET$p,1) #selected biomarker

  ET$node.hat=rep(ET$terminal,ET$n)  #estimated terminal node, i.e. subgroup, for each subject
  ET$marker.hat=rep(ET$marker,ET$n)  #estimated marker for each subj

  return(ET)
}
