% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cielab_coldist.R
\name{cielab_coldist}
\alias{cielab_coldist}
\title{Generate a 'coldist' object for CIE Lab colors}
\usage{
cielab_coldist(rgbcols)
}
\arguments{
\item{rgbcols}{An nx3 matrix of RGB colors (rows are colors and
columns are R, G, and B channels).}
}
\value{
A \link[pavo:coldist]{pavo::coldist} object with four columns: the patches
being contrasted (columns 1-2), the chromatic contrast (\code{dS}),
and the achromatic contrast (\code{dL}), all in units of Euclidean
distance in CIE Lab space.
}
\description{
A stopgap function for generating a \link[pavo:coldist]{pavo::coldist} object
from CIE Lab colors. This a pretty serious abstraction of the
original intention of a \code{coldist} object, which is to use
a combination of spectra data, visual model, and/or receptor-noise
model to calculate perceived chromatic and achromatic distances
between colors. Because CIE Lab color space is an approximately
perceptually uniform color space for human vision, we can calculate
a version of those distances for a human viewer directly from
CIE Lab. A decent option if you want preliminary results,
if you only care about human perception, or if you don't have access
to spectral data.
}
\details{
I have mixed feelings about this function and would like to
replace it with something a little less hand-wavey.
}
