% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorClusters.R
\name{colorClustersKMeans}
\alias{colorClustersKMeans}
\title{Cluster pixel colors using K-means clustering}
\usage{
colorClustersKMeans(
  pixel_matrix,
  n = 10,
  color_space = "Lab",
  ref_white = "D65"
)
}
\arguments{
\item{pixel_matrix}{2D matrix of pixels to classify (rows = pixels, columns =
channels).}

\item{n}{Number of clusters to fit.}

\item{color_space}{Color space in which to cluster colors, passed to
\code{[grDevices]{convertColor}}. One of "sRGB", "Lab", "Luv", or
"XYZ". Default is "Lab", a perceptually uniform (for humans) color space.}

\item{ref_white}{Reference white for converting to different color spaces.
D65 (the default) corresponds to standard daylight.}
}
\value{
A list with the following elements:
\enumerate{
\item \code{pixel_assignments}: A vector of color center assignments for each pixel.
\item \code{centers}: A matrix of color centers.
\item \code{sizes}: The number of pixels assigned to each cluster.
}
}
\description{
Clusters pixel colors using \code{\link[stats:kmeans]{stats::kmeans()}}.
}
\details{
Called by \code{\link[=colorClusters]{colorClusters()}}. See that documentation for
examples.
}
