% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructImage.R
\name{constructImage}
\alias{constructImage}
\title{Generate an image from pixel assignments and color matrix}
\usage{
constructImage(pixel_assignments, centers, background_color = "white")
}
\arguments{
\item{pixel_assignments}{A matrix of index values for each pixel which
corresponds to \code{centers} (e.g. a \code{1} indicates that pixel is the
color of the first row of \code{centers}). Pixels with an index value of 0
are considered background.}

\item{centers}{An n x 3 matrix of color centers where rows are colors
and columns are R, G, and B channels.}

\item{background_color}{A numeric RGB triplet, a hex code, or a named
R color for the background. Will be masked by alpha channel (and appear
white in the plot window), but will be revealed if the alpha
channel is removed. If the alpha channel is a background mask,
this is the 'baked in' background color.}
}
\value{
An image (raster) array of the recolored image,
with four channels (R, G, B, and alpha).
}
\description{
Combines a matrix of pixel assignments and a corresponding
matrix of colors to make a recolored RGB image.
}
