/*
 * Decompiled with CFR 0.152.
 */
class IceKey {
    private int size;
    private int rounds;
    private int[][] keySchedule;
    private static int[][] spBox;
    private static boolean spBoxInitialised;
    private static final int[][] sMod;
    private static final int[][] sXor;
    private static final int[] pBox;
    private static final int[] keyrot;

    private int gf_mult(int n, int n2, int n3) {
        int n4 = 0;
        while (n2 != 0) {
            if ((n2 & 1) != 0) {
                n4 ^= n;
            }
            n2 >>>= 1;
            if ((n <<= 1) < 256) continue;
            n ^= n3;
        }
        return n4;
    }

    private int gf_exp7(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        int n3 = this.gf_mult(n, n, n2);
        n3 = this.gf_mult(n, n3, n2);
        n3 = this.gf_mult(n3, n3, n2);
        return this.gf_mult(n, n3, n2);
    }

    private int perm32(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n != 0) {
            if ((n & 1) != 0) {
                n2 |= pBox[n3];
            }
            ++n3;
            n >>>= 1;
        }
        return n2;
    }

    private void spBoxInit() {
        spBox = new int[4][1024];
        int n = 0;
        while (n < 1024) {
            int n2 = n >>> 1 & 0xFF;
            int n3 = n & 1 | (n & 0x200) >>> 8;
            int n4 = this.gf_exp7(n2 ^ sXor[0][n3], sMod[0][n3]) << 24;
            IceKey.spBox[0][n] = this.perm32(n4);
            n4 = this.gf_exp7(n2 ^ sXor[1][n3], sMod[1][n3]) << 16;
            IceKey.spBox[1][n] = this.perm32(n4);
            n4 = this.gf_exp7(n2 ^ sXor[2][n3], sMod[2][n3]) << 8;
            IceKey.spBox[2][n] = this.perm32(n4);
            n4 = this.gf_exp7(n2 ^ sXor[3][n3], sMod[3][n3]);
            IceKey.spBox[3][n] = this.perm32(n4);
            ++n;
        }
    }

    IceKey(int n) {
        if (!spBoxInitialised) {
            this.spBoxInit();
            spBoxInitialised = true;
        }
        if (n < 1) {
            this.size = 1;
            this.rounds = 8;
        } else {
            this.size = n;
            this.rounds = n * 16;
        }
        this.keySchedule = new int[this.rounds][3];
    }

    private void scheduleBuild(int[] nArray, int n, int n2) {
        int n3 = 0;
        while (n3 < 8) {
            int n4 = keyrot[n2 + n3];
            int[] nArray2 = this.keySchedule[n + n3];
            int n5 = 0;
            while (n5 < 3) {
                this.keySchedule[n + n3][n5] = 0;
                ++n5;
            }
            n5 = 0;
            while (n5 < 15) {
                int n6 = n5 % 3;
                int n7 = 0;
                while (n7 < 4) {
                    int n8 = nArray[n4 + n7 & 3];
                    int n9 = n8 & 1;
                    nArray2[n6] = nArray2[n6] << 1 | n9;
                    nArray[n4 + n7 & 3] = n8 >>> 1 | (n9 ^ 1) << 15;
                    ++n7;
                }
                ++n5;
            }
            ++n3;
        }
    }

    public void set(byte[] byArray) {
        int[] nArray = new int[4];
        if (this.rounds == 8) {
            int n = 0;
            while (n < 4) {
                nArray[3 - n] = (byArray[n * 2] & 0xFF) << 8 | byArray[n * 2 + 1] & 0xFF;
                ++n;
            }
            this.scheduleBuild(nArray, 0, 0);
            return;
        }
        int n = 0;
        while (n < this.size) {
            int n2 = 0;
            while (n2 < 4) {
                nArray[3 - n2] = (byArray[n * 8 + n2 * 2] & 0xFF) << 8 | byArray[n * 8 + n2 * 2 + 1] & 0xFF;
                ++n2;
            }
            this.scheduleBuild(nArray, n * 8, 0);
            this.scheduleBuild(nArray, this.rounds - 8 - n * 8, 8);
            ++n;
        }
    }

    public void clear() {
        int n = 0;
        while (n < this.rounds) {
            int n2 = 0;
            while (n2 < 3) {
                this.keySchedule[n][n2] = 0;
                ++n2;
            }
            ++n;
        }
    }

    private int roundFunc(int n, int[] nArray) {
        int n2 = n >>> 16 & 0x3FF | (n >>> 14 | n << 18) & 0xFFC00;
        int n3 = n & 0x3FF | n << 2 & 0xFFC00;
        int n4 = nArray[2] & (n2 ^ n3);
        int n5 = n4 ^ n3;
        n4 ^= n2;
        return spBox[0][(n4 ^= nArray[0]) >>> 10] | spBox[1][n4 & 0x3FF] | spBox[2][(n5 ^= nArray[1]) >>> 10] | spBox[3][n5 & 0x3FF];
    }

    public void encrypt(byte[] byArray, byte[] byArray2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < 4) {
            n |= (byArray[n3] & 0xFF) << 24 - n3 * 8;
            n2 |= (byArray[n3 + 4] & 0xFF) << 24 - n3 * 8;
            ++n3;
        }
        n3 = 0;
        while (n3 < this.rounds) {
            n2 ^= this.roundFunc(n ^= this.roundFunc(n2, this.keySchedule[n3]), this.keySchedule[n3 + 1]);
            n3 += 2;
        }
        n3 = 0;
        while (n3 < 4) {
            byArray2[3 - n3] = (byte)(n2 & 0xFF);
            byArray2[7 - n3] = (byte)(n & 0xFF);
            n2 >>>= 8;
            n >>>= 8;
            ++n3;
        }
    }

    public void decrypt(byte[] byArray, byte[] byArray2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < 4) {
            n |= (byArray[n3] & 0xFF) << 24 - n3 * 8;
            n2 |= (byArray[n3 + 4] & 0xFF) << 24 - n3 * 8;
            ++n3;
        }
        n3 = this.rounds - 1;
        while (n3 > 0) {
            n2 ^= this.roundFunc(n ^= this.roundFunc(n2, this.keySchedule[n3]), this.keySchedule[n3 - 1]);
            n3 -= 2;
        }
        n3 = 0;
        while (n3 < 4) {
            byArray2[3 - n3] = (byte)(n2 & 0xFF);
            byArray2[7 - n3] = (byte)(n & 0xFF);
            n2 >>>= 8;
            n >>>= 8;
            ++n3;
        }
    }

    public int keySize() {
        return this.size * 8;
    }

    public int blockSize() {
        return 8;
    }

    static {
        sMod = new int[][]{{333, 313, 505, 369}, {379, 375, 319, 391}, {361, 445, 451, 397}, {397, 425, 395, 505}};
        sXor = new int[][]{{131, 133, 155, 205}, {204, 167, 173, 65}, {75, 46, 212, 51}, {234, 203, 46, 4}};
        pBox = new int[]{1, 128, 1024, 8192, 524288, 0x200000, 0x1000000, 0x40000000, 8, 32, 256, 16384, 65536, 0x800000, 0x4000000, 0x20000000, 4, 16, 512, 32768, 131072, 0x400000, 0x8000000, 0x10000000, 2, 64, 2048, 4096, 262144, 0x100000, 0x2000000, Integer.MIN_VALUE};
        keyrot = new int[]{0, 1, 2, 3, 2, 1, 3, 0, 1, 3, 2, 0, 3, 1, 0, 2};
    }
}

