/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;

class Snow {
    private static BufferedReader stream_in;
    private static OutputStream stream_out;
    private static InputStream stream_message;
    private static boolean compress_flag;
    private static boolean quiet_flag;
    private static boolean space_flag;
    private static String passwd_string;
    private static int line_length;

    private static boolean parse_args(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length && stringArray[n].charAt(0) == '-') {
            if (stringArray[n].length() < 2) {
                return false;
            }
            switch (stringArray[n].charAt(1)) {
                case 'C': {
                    compress_flag = true;
                    break;
                }
                case 'Q': {
                    quiet_flag = true;
                    break;
                }
                case 'S': {
                    space_flag = true;
                    break;
                }
                case 'f': {
                    String string;
                    if (stringArray[n].length() > 2) {
                        string = stringArray[n].substring(2);
                    } else {
                        if (++n == stringArray.length) {
                            return false;
                        }
                        string = stringArray[n];
                    }
                    if (stream_message != null) {
                        System.err.println("Multiple message inputs defined.");
                        return false;
                    }
                    try {
                        stream_message = new FileInputStream(string);
                        break;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        System.err.println("No such file: " + string);
                        return false;
                    }
                }
                case 'l': {
                    String string;
                    if (stringArray[n].length() > 2) {
                        string = stringArray[n].substring(2);
                    } else {
                        if (++n == stringArray.length) {
                            return false;
                        }
                        string = stringArray[n];
                    }
                    try {
                        line_length = Integer.parseInt(string);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("Illegal line length: " + string);
                        return false;
                    }
                }
                case 'm': {
                    String string;
                    if (stringArray[n].length() > 2) {
                        string = stringArray[n].substring(2);
                    } else {
                        if (++n == stringArray.length) {
                            return false;
                        }
                        string = stringArray[n];
                    }
                    if (stream_message != null) {
                        System.err.println("Multiple message inputs defined.");
                        return false;
                    }
                    stream_message = new ByteArrayInputStream(string.getBytes());
                    break;
                }
                case 'p': {
                    String string;
                    if (stringArray[n].length() > 2) {
                        string = stringArray[n].substring(2);
                    } else {
                        if (++n == stringArray.length) {
                            return false;
                        }
                        string = stringArray[n];
                    }
                    passwd_string = string;
                    break;
                }
                default: {
                    System.err.println("Illegal option: " + stringArray[n]);
                    return false;
                }
            }
            ++n;
        }
        if (n < stringArray.length - 2) {
            return false;
        }
        if (n < stringArray.length) {
            try {
                stream_in = new BufferedReader(new FileReader(stringArray[n]));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("No such file: " + stringArray[n]);
                return false;
            }
        } else {
            stream_in = new BufferedReader(new InputStreamReader(System.in));
        }
        if (!space_flag && n + 1 < stringArray.length) {
            try {
                stream_out = new FileOutputStream(stringArray[n + 1]);
            }
            catch (IOException iOException) {
                System.err.println("Could not open file for writing: " + stringArray[n + 1]);
                return false;
            }
        } else {
            stream_out = System.out;
        }
        return true;
    }

    private static boolean message_encode(BitFilter bitFilter) {
        try {
            int n;
            while ((n = stream_message.read()) != -1) {
                int n2 = 0;
                while (n2 < 8) {
                    if (!bitFilter.receive_bit((n & 128 >> n2) != 0)) {
                        return false;
                    }
                    ++n2;
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("Failed to read from message stream.");
            return false;
        }
        return bitFilter.flush();
    }

    public static void main(String[] stringArray) {
        if (!Snow.parse_args(stringArray)) {
            System.err.print("Usage: Snow.class [-C][-Q][-S]");
            System.err.print("[-p passwd][-l line-len]");
            System.err.println(" [-f file][-m message]");
            System.err.println("\t\t\t\t\t[infile [outfile]]");
            System.exit(1);
        }
        if (space_flag) {
            SnowEncode snowEncode = new SnowEncode(true, quiet_flag, null, stream_in, null, line_length);
            snowEncode.space_calculate();
        } else if (stream_message != null) {
            PrintWriter printWriter = new PrintWriter(stream_out);
            BitFilter bitFilter = new SnowEncode(true, quiet_flag, null, stream_in, printWriter, line_length);
            if (passwd_string != null) {
                bitFilter = new SnowEncrypt(true, quiet_flag, bitFilter, passwd_string);
            }
            if (compress_flag) {
                bitFilter = new SnowCompress(true, quiet_flag, bitFilter);
            }
            if (!Snow.message_encode(bitFilter)) {
                System.exit(1);
            }
            printWriter.close();
        } else {
            SnowEncode snowEncode;
            BitFilter bitFilter = new SnowOutput(quiet_flag, stream_out);
            if (compress_flag) {
                bitFilter = new SnowCompress(false, quiet_flag, bitFilter);
            }
            if (passwd_string != null) {
                bitFilter = new SnowEncrypt(false, quiet_flag, bitFilter, passwd_string);
            }
            if (!(snowEncode = new SnowEncode(false, quiet_flag, bitFilter, stream_in, null, line_length)).decode()) {
                System.exit(1);
            }
            try {
                stream_out.close();
            }
            catch (IOException iOException) {
                System.err.println("Problem closing output file.");
                System.exit(1);
            }
        }
        try {
            stream_in.close();
            return;
        }
        catch (IOException iOException) {
            System.err.println("Problem closing input file.");
            System.exit(1);
            return;
        }
    }

    Snow() {
    }

    static {
        stream_message = null;
        passwd_string = null;
        line_length = 80;
    }
}

