/*
 * Decompiled with CFR 0.152.
 */
class SnowEncrypt
extends BitFilter {
    private IceKey key;
    private byte[] iv_block;
    private boolean encode_flag = false;
    private boolean quiet_flag = false;
    private BitFilter next_filter;

    SnowEncrypt(boolean bl, boolean bl2, BitFilter bitFilter, String string) {
        this.encode_flag = bl;
        this.quiet_flag = bl2;
        this.set_key(string);
        this.next_filter = bitFilter;
    }

    private void set_key(String string) {
        byte[] byArray = string.getBytes();
        int n = (byArray.length * 7 + 63) / 64;
        if (n == 0) {
            if (!this.quiet_flag) {
                System.err.println("Warning: an empty password is being used.");
            }
            n = 1;
        } else if (n > 128) {
            if (!this.quiet_flag) {
                System.err.println("Warning: password truncated to 1170 chars.");
            }
            n = 128;
        }
        this.key = new IceKey(n);
        byte[] byArray2 = new byte[n * 8];
        int n2 = 0;
        int n3 = 0;
        while (n3 < byArray.length) {
            int n4 = byArray[n3] & 0x7F;
            int n5 = n2 / 8;
            int n6 = n2 & 7;
            if (n6 == 0) {
                byArray2[n5] = (byte)(n4 << 1);
            } else if (n6 == 1) {
                int n7 = n5;
                byArray2[n7] = (byte)(byArray2[n7] | n4);
            } else {
                int n8 = n5;
                byArray2[n8] = (byte)(byArray2[n8] | n4 >>> n6 - 1);
                byArray2[n5 + 1] = (byte)(n4 << 9 - n6);
            }
            ++n3;
            if ((n2 += 7) > 8184) break;
        }
        this.key.set(byArray2);
        this.iv_block = new byte[8];
        this.key.encrypt(byArray2, this.iv_block);
    }

    public boolean receive_bit(boolean bl) {
        if (this.key == null) {
            return this.next_filter.receive_bit(bl);
        }
        if (this.encode_flag) {
            byte[] byArray = new byte[8];
            this.key.encrypt(this.iv_block, byArray);
            if ((byArray[0] & 0x80) != 0) {
                bl = !bl;
            }
            int n = 0;
            while (n < 8) {
                int n2 = n;
                this.iv_block[n2] = (byte)(this.iv_block[n2] << 1);
                if (n < 7 && (this.iv_block[n + 1] & 0x80) != 0) {
                    int n3 = n;
                    this.iv_block[n3] = (byte)(this.iv_block[n3] | 1);
                }
                ++n;
            }
            this.iv_block[7] = (byte)(this.iv_block[7] | (bl ? (byte)1 : 0));
            return this.next_filter.receive_bit(bl);
        }
        byte[] byArray = new byte[8];
        this.key.encrypt(this.iv_block, byArray);
        boolean bl2 = (byArray[0] & 0x80) != 0 ? !bl : bl;
        int n = 0;
        while (n < 8) {
            int n4 = n;
            this.iv_block[n4] = (byte)(this.iv_block[n4] << 1);
            if (n < 7 && (this.iv_block[n + 1] & 0x80) != 0) {
                int n5 = n;
                this.iv_block[n5] = (byte)(this.iv_block[n5] | 1);
            }
            ++n;
        }
        this.iv_block[7] = (byte)(this.iv_block[7] | (bl ? (byte)1 : 0));
        return this.next_filter.receive_bit(bl2);
    }

    public boolean flush() {
        return this.next_filter.flush();
    }
}

