<?php

/*********************************************************************
 *
 * tokengrid, a strong authentication token grid PHP class
 *
 * Demo file, require tokengrid.class.php
 *
 *********************************************************************/

require_once('tokengrid.class.php');

?>
<html>
    <head>
        <title>
            Strong Authentication Token Grid demo
        </title>
        <style>
            table,th,td {
                border: 1px solid #000000;
                border-collapse: collapse;
                font-family: Verdana;
                padding: 5px;
                text-align: center;
            }
        </style>
    </head>
    <body>
        <form method="post" action="<?php echo $_SERVER['PHP_SELF']; ?>">
        <?php
            $x_grid_size = 10;
            $y_grid_size = 10;
            $token_length = 4;
            $grid_id = 'demo-grid-2008';
            $grid_salt = 'tokengridDEMO';
            
            $token_grid = new TokenGrid($x_grid_size, $y_grid_size, $token_length, $grid_salt);

            if ((isset($_POST['token'])) && (isset($_POST['position'])))
            {
                $token = $_POST['token'];
                $position = $_POST['position'];
                
                if ($token_grid->IsTokenValid($position, $grid_id, $token))
                {
                    echo "Yes, the last token at position ".$position." was correct (".$token.")";
                    echo "<br /><br />";
                }
                else
                {
                    echo "NO, the last token at position ".$position." was incorrect (".$token.")";
                    echo "<br /><br />";
                }
            }

            echo "<h3>Here is your personal token grid (normally printed on a separate credit card sized paper)</h3>";
            echo "<br />";
            echo $token_grid->GetXhtmlGrid($grid_id);
            echo "TokenGrid ID: ".$grid_id;
            echo "<br /><br />";
            
            $random_position = $token_grid->GetRandomGridPosition($grid_id);
            
            echo "Check your TokenGrid at this position: <b>";
            echo $random_position;
            echo "</b>";
            echo " <input type=\"text\" size=\"10\" value=\"\" name=\"token\" id=\"token\" />";
            echo " <input type=\"hidden\" value=\"".$random_position."\" name=\"position\" id=\"position\" />";
            echo " <input type=\"submit\" value=\"Submit\" name=\"submit\" id=\"submit\" />";
        ?>
        </form>
    </body>
<html>
