#!/bin/bash

ES_BINARY=/home/grant/elasticsearch-0.18.7/bin/elasticsearch

if [ -z "$1" ]
then
    sudo $0 as-root $USER
    stty sane
elif [ "$1" = "as-root" ]
then
    ORIGINAL_USER=$2
    echo "Increasing ulimit"
    ulimit -n 4096
    su -c "$0 start-es" $ORIGINAL_USER
elif [ "$1" = "start-es" ]
then
    echo "Starting ES"
    $ES_BINARY &
    sleep 5
else
    echo "Unknown argument: '$1'"
fi
