(function(Proton, undefined) {
    var ColorUtil = ColorUtil || {
        getRGB: function(color) {
            var rgb = {};
            if (typeof color === 'number') {
                hex = Math.floor(color);
                rgb.r = (color >> 16 & 255) / 255;
                rgb.g = (color >> 8 & 255) / 255;
                rgb.b = (color & 255) / 255;
            } else if (typeof color === 'string') {
                var m;
                if (m = /^(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*(,\s*([0-9]*\.?[0-9]+)\s*)?$/.exec(color)) {
                    rgb.r = Math.min(255, parseInt(m[1], 10)) / 255;
                    rgb.g = Math.min(255, parseInt(m[2], 10)) / 255;
                    rgb.b = Math.min(255, parseInt(m[3], 10)) / 255;
                } else if (m = /^\#([A-Fa-f0-9]+)$/.exec(color)) {
                    var hex = m[1];
                    rgb.r = parseInt(hex.charAt(0) + hex.charAt(1), 16) / 255;
                    rgb.g = parseInt(hex.charAt(2) + hex.charAt(3), 16) / 255;
                    rgb.b = parseInt(hex.charAt(4) + hex.charAt(5), 16) / 255;
                }
            } else if (color instanceof THREE.Color) {
                rgb.r = color.r;
                rgb.g = color.g;
                rgb.b = color.b;
            }

            return rgb;
        }
    };


    Proton.ColorUtil = ColorUtil;
})(Proton);
