﻿// card.cpp
#include "card.h"
#include <algorithm>
#include <random>

// トランプを初期化する
void init_trump(cards_type& cards)
{
    for (auto i = 0; i < each_mark_card_num; ++i) {
        auto number = static_cast<CardNumber>(i + 1);
        cards.at(i + each_mark_card_num * 0).number = number;
        cards.at(i + each_mark_card_num * 0).mark = CardMark::spade;
        cards.at(i + each_mark_card_num * 1).number = number;
        cards.at(i + each_mark_card_num * 1).mark = CardMark::club;
        cards.at(i + each_mark_card_num * 2).number = number;
        cards.at(i + each_mark_card_num * 2).mark = CardMark::diamond;
        cards.at(i + each_mark_card_num * 3).number = number;
        cards.at(i + each_mark_card_num * 3).mark = CardMark::heart;
    }
}

// カードをシャッフルする
void shuffle_cards(cards_type& cards)
{
    std::random_device rand_dev {};
    std::mt19937 rand_engine(rand_dev());
    std::shuffle(std::begin(cards), std::end(cards), rand_engine);
}

// カードを整列する
void sort_cards(cards_type& cards)
{
    std::sort(std::begin(cards), std::end(cards), cards_sort_compare);
}

// カードの整列に使う比較関数
bool cards_sort_compare(const Card& a, const Card& b)
{
    if (a.number == b.number) {
        return a.mark < b.mark;
    }
    return a.number < b.number;
}

// カードの数字の文字列表現を返す
utf8_string get_card_number_string(CardNumber number)
{
    switch (number) {
    case 1:     return u8"A";
    case 2:     return u8"2";
    case 3:     return u8"3";
    case 4:     return u8"4";
    case 5:     return u8"5";
    case 6:     return u8"6";
    case 7:     return u8"7";
    case 8:     return u8"8";
    case 9:     return u8"9";
    case 10:    return u8"10";
    case 11:    return u8"J";
    case 12:    return u8"Q";
    case 13:    return u8"K";
    default:    return u8"";
    }
}

// カードのマークの文字列表現を返す
utf8_string get_mark_string(CardMark card_mark)
{
#if CARD_MARK_STRING == CARD_MARK_STRING_EMOJI
    switch (card_mark) {
    case CardMark::spade:
        return u8"♠";
    case CardMark::club:
        return u8"♣";
    case CardMark::diamond:
        return u8"♦";
    case CardMark::heart:
        return u8"♥";
    default:
        return u8"";
    }
#elif CARD_MARK_STRING == CARD_MARK_STRING_KANA
    switch (card_mark) {
    case CardMark::spade:
        return u8"スペード";
    case CardMark::club:
        return u8"クラブ";
    case CardMark::diamond:
        return u8"ダイヤ";
    case CardMark::heart:
        return u8"ハート";
    default:
        return u8"";
    }
#elif CARD_MARK_STRING == CARD_MARK_STRING_ALPHABET
    switch (card_mark) {
    case CardMark::spade:
        return u8"spade";
    case CardMark::club:
        return u8"club";
    case CardMark::diamond:
        return u8"diamond";
    case CardMark::heart:
        return u8"heart";
    default:
        return u8"";
    }
#else
    #error "invalid CARD_MARK_STRING."
#endif
}
