﻿// strean.h
#ifndef STREAM_H_INCLUDED
#define STREAM_H_INCLUDED

#include <iostream>
#include <string>

#ifdef __cpp_char8_t

// UTF-8 を扱うための型
using utf8_char = char8_t;
using utf8_string = std::u8string;

// UTF-8 の文字、文字列を出力する
inline std::ostream& operator<<(std::ostream& os, utf8_char s) {
    return os << static_cast<char>(s);
}
inline std::ostream& operator<<(std::ostream& os, const utf8_char* s) {
    return os << reinterpret_cast<const char*>(s);
}
inline std::ostream& operator<<(std::ostream& os, const utf8_string& s) {
    return os << s.c_str();
}
#else

// UTF-8 を扱うための型
using utf8_char = char;
using utf8_string = std::string;

#endif

#endif
