% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cytomethic.R
\name{cmi_predict}
\alias{cmi_predict}
\title{The cmi_predict function takes in a model and a sample, and uses the model
to predict it.  This function supports randomForest, e1071::svm, xgboost,
and keras/tensorflow models. For xgboost and keras models, the features used
in classification as well as a label mapping must be provided for output.}
\usage{
cmi_predict(betas, cmi_model, verbose = FALSE, BPPARAM = SerialParam())
}
\arguments{
\item{betas}{DNA methylation beta}

\item{cmi_model}{Cytomethic model downloaded from ExperimentHub}

\item{verbose}{be verbose with warning}

\item{BPPARAM}{use MulticoreParam(n) for parallel processing}
}
\value{
predicted cancer type label
}
\description{
The cmi_predict function takes in a model and a sample, and uses the model
to predict it.  This function supports randomForest, e1071::svm, xgboost,
and keras/tensorflow models. For xgboost and keras models, the features used
in classification as well as a label mapping must be provided for output.
}
\examples{

library(sesame)
library(ExperimentHub)
library(CytoMethIC)

## Cancer Type
model = ExperimentHub()[["EH8395"]]
betas = openSesame(sesameDataGet("EPICv2.8.SigDF")[[1]])
betas = imputeBetas(mLiftOver(betas, "HM450"))
cmi_predict(betas, model)

betas = openSesame(sesameDataGet('EPIC.1.SigDF'), mask=FALSE)
cmi_predict(betas, model)

betas = sesameDataGet("HM450.1.TCGA.PAAD")$betas
betas = imputeBetas(betas)
cmi_predict(betas, model)

}
