/*
 * Decompiled with CFR 0.152.
 */
package elte.community;

import elte.community.Clique;
import elte.community.Edge;
import elte.community.visual.settings.Parameters;
import java.awt.Color;
import java.util.Iterator;
import java.util.TreeSet;

public class Community {
    private TreeSet vertices = new TreeSet();
    private TreeSet edges = new TreeSet();
    private TreeSet cliques = new TreeSet();
    private int size;
    private int index;
    private Color color = new Color(Parameters.NODE_COLOR.getRGB());
    public Color labelColor = Color.WHITE;
    public boolean approximated;
    public static Color[] colors = new Color[]{new Color(Color.HSBtoRGB(0.0f, 0.9f, 0.9f)), new Color(Color.HSBtoRGB(0.05f, 0.9f, 0.9f)), new Color(Color.HSBtoRGB(0.1f, 0.9f, 0.9f)), new Color(Color.HSBtoRGB(0.15f, 0.9f, 0.9f)), new Color(Color.HSBtoRGB(0.2f, 0.9f, 0.9f)), new Color(Color.HSBtoRGB(0.25f, 0.9f, 0.9f)), new Color(Color.HSBtoRGB(0.3f, 0.9f, 0.9f)), new Color(Color.HSBtoRGB(0.35f, 0.9f, 0.9f)), new Color(Color.HSBtoRGB(0.4f, 0.9f, 0.9f)), new Color(Color.HSBtoRGB(0.45f, 0.9f, 0.9f)), new Color(Color.HSBtoRGB(0.5f, 0.9f, 0.9f)), new Color(Color.HSBtoRGB(0.55f, 0.9f, 0.9f)), new Color(Color.HSBtoRGB(0.6f, 0.9f, 0.9f)), new Color(Color.HSBtoRGB(0.65f, 0.9f, 0.9f)), new Color(Color.HSBtoRGB(0.7f, 0.9f, 0.9f)), new Color(Color.HSBtoRGB(0.75f, 0.9f, 0.9f)), new Color(Color.HSBtoRGB(0.8f, 0.9f, 0.9f)), new Color(Color.HSBtoRGB(0.85f, 0.9f, 0.9f)), new Color(Color.HSBtoRGB(0.9f, 0.9f, 0.9f)), new Color(Color.HSBtoRGB(0.95f, 0.9f, 0.9f)), new Color(Color.HSBtoRGB(1.0f, 0.9f, 0.9f))};

    public Community() {
        Color c;
        this.color = c = colors[(int)Math.floor(Math.random() * (double)colors.length)];
        this.approximated = false;
    }

    public Community(boolean approximated) {
        Color c;
        this.color = c = colors[(int)Math.floor(Math.random() * (double)colors.length)];
        this.approximated = approximated;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setNewRandomColor() {
        Color c;
        this.color = c = colors[(int)Math.floor(Math.random() * (double)colors.length)];
    }

    public void addEdge(Edge e) {
        this.edges.add(e);
    }

    public TreeSet getEdges() {
        return this.edges;
    }

    public void addVertex(String s) {
        this.vertices.add(s);
    }

    public TreeSet getVertices() {
        return this.vertices;
    }

    public void addClique(Clique c) {
        this.cliques.add(c);
    }

    public TreeSet getCliques() {
        return this.cliques;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int s) {
        this.size = s;
    }

    public String getVerticesString() {
        String ret = "";
        Iterator i = this.vertices.iterator();
        while (i.hasNext()) {
            ret = ret + i.next().toString() + " ";
        }
        return ret;
    }

    public String getEdgesString() {
        String ret = "";
        Iterator i = this.edges.iterator();
        while (i.hasNext()) {
            ret = ret + i.next().toString() + ", ";
        }
        return ret;
    }

    public String getTempLabel() {
        return this.index + ". (k=" + this.size + ")";
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int i) {
        this.index = i;
    }
}

